import React from 'react';
import {Spin} from '@yandex-lego/components/Spin/desktop/bundle';
import {Link, withRouter} from 'react-router-dom';
import {Link as LegoLink} from '@yandex-lego/components/Link/desktop/bundle';
import {Button} from '@yandex-lego/components/Button/desktop/bundle';
import {Textinput} from '@yandex-lego/components/Textinput/desktop/bundle';

import {apiAddTask, apiSearch, taskUrl} from '../../startrek';


const BASE_URL = window.location.host === 'pages.github.yandex-team.ru' ? '/traden/planner/quarters' : '/quarters';

class QuarterList extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            loading: true,
            tasks: [],
            inputQueue: '',
            inputQueueState: '',
            inputQueueHint: '',
            inputName: '',
            inputNameState: '',
            inputNameHint: '',
            saveBoardLocked: false,
            addBoardError: '',
        };
    }

    onQueryLoaded = (tasks) => {
        tasks.sort((t1, t2) => t1.summary < t2.summary ? -1 : 1);
        this.setState({loading: false, tasks});
    };

    componentDidMount() {
        apiSearch('Tags: planner_quarter')
            .then(this.onQueryLoaded);
    }

    onSaveQuarter = async () => {
        const {inputQueue, inputName} = this.state;
        let hasErrors = false;
        this.setState({
            inputQueueState: '',
            inputQueueHint: '',
            inputNameState: '',
            inputNameHint: '',
        });
        if (!inputQueue) {
            this.setState({inputQueueState: 'error', inputQueueHint: 'Надо заполнить'});
            hasErrors = true;
        }
        if (!inputName) {
            this.setState({inputNameState: 'error', inputNameHint: 'Надо заполнить'});
            hasErrors = true;
        }
        if (hasErrors) {
            return;
        }
        this.setState({saveBoardLocked: true});
        const taskProps = {
            queue: inputQueue,
            summary: inputName,
            tags: ['planner_quarter'],
        };
        const newTask = await apiAddTask(taskProps);
        if (!newTask) {
            this.setState({
                addBoardError: 'Ошибка сохранение доски',
                saveBoardLocked: false,
            });
            return;
        }
        this.props.history.push(`${BASE_URL}/` + newTask.key);
    };

    render() {
        return (
            <div>
                <h1>Кварталы</h1>
                {
                    this.state.loading &&
                    <div id='FetchDataSpinner'>
                        <Spin progress view='default' size='m' />
                    </div>
                }
                {!this.state.loading && !this.state.tasks.length && 'Нет досок'}
                {
                    !this.state.loading && !!this.state.tasks.length &&
                    <>
                        {this.state.tasks.map(task => (
                            <div key={task.key}>
                                <Link class='Link_view_default' size='xs' view='default' to={`${BASE_URL}/` + task.key}>
                                    {task.summary}
                                </Link>
                                &nbsp;&nbsp;
                                <LegoLink target='_blank' size='xs' theme='ghost' href={taskUrl(task.key)}>
                                    {task.key}
                                </LegoLink>
                            </div>
                        ))}
                    </>
                }
                <br />
                <br />
                {!this.state.showAddBoard &&
                    <Button
                        view='action'
                        size='s'
                        onClick={() => this.setState({showAddBoard: true})}
                        disabled={this.state.loading}
                    >
                        Добавить доску
                    </Button>
                }
                {this.state.showAddBoard &&
                    <>
                        <h2>Добавление нового квартала</h2>
                        <div className='error'>{this.state.addBoardError}</div>
                        Очередь:
                        <br />
                        <Textinput
                            size='s'
                            view='default'
                            value={this.state.inputQueue}
                            state={this.state.inputQueueState}
                            hint={this.state.inputQueueHint}
                            onChange={(e) => this.setState({inputQueue: e.target.value})}
                        />
                        <br />
                        <br />
                        Название квартала:
                        <br />
                        <Textinput
                            size='s'
                            view='default'
                            value={this.state.inputName}
                            state={this.state.inputNameState}
                            hint={this.state.inputNameHint}
                            onChange={(e) => this.setState({inputName: e.target.value})}
                        />
                        <br />
                        <br />
                        <Button
                            view='action'
                            size='s'
                            onClick={this.onSaveQuarter}
                            disabled={this.state.saveBoardLocked}
                        >
                            Сохранить
                        </Button>
                        <Button
                            view='clear'
                            size='s'
                            onClick={() => this.setState({showAddBoard: false})}
                        >
                            Отмена
                        </Button>
                    </>
                }
            </div>
        );
    }
}

export default withRouter(QuarterList);
