import {RightPanel} from "./RightPanel";
import React from "react";

type RightPanelStoryState = {
    panelVisible: boolean,
    panelContent: string,
}

class RightPanelStory extends React.PureComponent<{}, RightPanelStoryState> {
    constructor(props: any) {
        super(props);
        this.state = {
            panelVisible: false,
            panelContent: 'aaa',
        }
    }

    onPanelClose = () => {
        this.setState({
            panelVisible: false
        })
    }

    onOpenPanel = (content: string) => {
        this.setState({
            panelVisible: true,
            panelContent: content,
        })
    }

    render() {
        return (
            <div>
                {this.state.panelVisible &&
                <RightPanel onClose={this.onPanelClose}>
                    {this.state.panelContent}
                </RightPanel>
                }
                <button onClick={() => this.onOpenPanel('content 1')}>
                    open panel 1
                </button>
                <br /><br />
                <button onClick={() => this.onOpenPanel('content 2')}>
                    open panel 2
                </button>
            </div>
        );
    }
}

const storybookMeta = {
    component: RightPanel,
    title: 'RightPanel',
}

export default storybookMeta;

// export const Primary: React.FC<{}> = (args) => (
//     <RightPanel {...args}>
//         content
//     </RightPanel>
// );

export const Primary: React.FC<{}> = () => <RightPanelStory />;
