import React from 'react';
import {Link} from 'react-router-dom';

import {Textinput} from '@yandex-lego/components/Textinput/desktop/bundle';
import {Text} from '@yandex-lego/components/Text/desktop/bundle';
import {Button} from '@yandex-lego/components/Button/desktop/bundle';
import {Checkbox} from '@yandex-lego/components/Checkbox/desktop/bundle';
import {SprintPlanner} from './SprintPlanner';
import {Modal} from '@yandex-lego/components/Modal/desktop/bundle';
import {parseArray} from '../../lib/functions';
import {TeamConfig} from '../TeamConfig/TeamConfig';
import {configureRootTheme} from '@yandex-lego/components/Theme';
// import {Tumbler as TumblerDesktop, withSizeM, withViewDefault} from '@yandex-lego/components/Tumbler/desktop';
// import {compose} from '@bem-react/core';
import {theme} from '@yandex-lego/components/Theme/presets/default';

// import btnAddTask from '../../assets/btnAddTask.svg';
// import btnUpdateGray from '../../assets/btnUpdateGray.svg';
// import btnUpdateYellow from '../../assets/btnUpdateYellow.svg';
import btnTeams from '../../assets/btnTeams.svg';
import btnSettings from '../../assets/btnSettings.svg';

configureRootTheme({theme});

// const Tumbler = compose(withSizeM, withViewDefault)(TumblerDesktop);

export class Configurator extends React.PureComponent {
    constructor(props) {
        super(props);
        const externalConfig = props.config;
        this.state = {
            params: {
                board: '',
                name: externalConfig.name,
                query: externalConfig.query,
                assignSprint: externalConfig.assignSprint,
                assignTags: externalConfig.assignTags,
                newTaskQueues: externalConfig.newTaskQueues,
                showTags: externalConfig.showTags,
                unsetSprint: externalConfig.unsetSprint,
                setSprintCandidateTag: externalConfig.setSprintCandidateTag,
                sprintCandidateTag: externalConfig.sprintCandidateTag,
                hideAssigneeTotals: externalConfig.hideAssigneeTotals,
                showWeight: externalConfig.showWeight,
                withoutStories: externalConfig.withoutStories,
                image: externalConfig.image,
                t1: externalConfig.t1,
                t2: externalConfig.t2,
                t3: externalConfig.t3,
                t4: externalConfig.t4,
            },
            inputBoardName: externalConfig.name,
            inputCssBackgroundImage: externalConfig.image,
            inputQuery: externalConfig.query,
            inputAssignSprint: externalConfig.assignSprint,
            inputAssignTags: externalConfig.assignTags,
            inputShowTags: externalConfig.showTags,
            inputNewTaskQueues: externalConfig.newTaskQueues,
            unsetSprint: externalConfig.unsetSprint === '1',
            setSprintCandidateTag: externalConfig.setSprintCandidateTag === '1',
            sprintCandidateTag: externalConfig.sprintCandidateTag,
            hideAssigneeTotals: externalConfig.hideAssigneeTotals === '1',
            showWeight: externalConfig.showWeight === '1',
            exportToTicket: false,
            withoutStories: externalConfig.withoutStories,
            exportTicket: '',
            sprints: [],
            teams: {
                1: this.parseTeamConfig(externalConfig.t1),
                2: this.parseTeamConfig(externalConfig.t2),
                3: this.parseTeamConfig(externalConfig.t3),
                4: this.parseTeamConfig(externalConfig.t4),
            },
            showPlanner: false,
            showConfig: false,
            showTeams: false,
            plannerParams: null,
            autoUpdate: false,
        };
    }

    onApply = () => {
        const {state} = this;
        const {teams} = state;
        this.saveExternalConfig({
            name: state.inputBoardName,
            query: state.inputQuery,
            assignSprint: state.inputAssignSprint,
            newTaskQueues: state.inputNewTaskQueues,
            assignTags: state.inputAssignTags,
            showTags: state.inputShowTags,
            unsetSprint: state.unsetSprint ? '1' : '',
            setSprintCandidateTag: state.setSprintCandidateTag ? '1' : '',
            sprintCandidateTag: state.sprintCandidateTag || 'candidate',
            hideAssigneeTotals: state.hideAssigneeTotals ? '1' : '',
            showWeight: state.showWeight ? '1' : '',
            withoutStories: state.withoutStories ? '1' : '',
            image: state.inputCssBackgroundImage,
            t1: this.serializeTeamConfig(state.teams['1']),
            t2: this.serializeTeamConfig(state.teams['2']),
            t3: this.serializeTeamConfig(state.teams['3']),
            t4: this.serializeTeamConfig(state.teams['4']),
        });
        const getTeam = (teamCompressed) => {
            const {name, tags, capacity, assignedTags} = teamCompressed;
            return {
                name,
                tags: parseArray(tags),
                assignedTags: parseArray(assignedTags),
                capacity: +capacity,
            };
        };

        const plannerTeams = [];
        if (teams['1'].name) {
            plannerTeams.push(getTeam(teams['1']));
        }
        if (teams['2'].name) {
            plannerTeams.push(getTeam(teams['2']));
        }
        if (teams['3'].name) {
            plannerTeams.push(getTeam(teams['3']));
        }
        if (teams['4'].name) {
            plannerTeams.push(getTeam(teams['4']));
        }
        this.setState({
            plannerParams: {
                query: state.inputQuery,
                assignSprint: state.inputAssignSprint,
                assignTags: parseArray(state.inputAssignTags),
                showTags: parseArray(state.inputShowTags),
                newTaskQueues: parseArray(state.inputNewTaskQueues),
                unsetSprint: state.unsetSprint,
                setSprintCandidateTag: state.setSprintCandidateTag,
                sprintCandidateTag: state.sprintCandidateTag,
                hideAssigneeTotals: state.hideAssigneeTotals,
                exportTicket: state.exportTicket,
                showWeight: state.showWeight,
                exportIntervalSeconds: Math.max(5, +state.exportIntervalSeconds),
                teams: plannerTeams,
                withoutStories: state.withoutStories,
                name: state.inputBoardName,
            },
        });
    };

    parseTeamConfig(strConfig) {
        const [name = '', tags = '', assignedTags = '', capacity = ''] = strConfig ? strConfig.split('|') : [];
        return {name, tags, assignedTags, capacity};
    }

    serializeTeamConfig({name, tags, capacity, assignedTags}) {
        if (!name && !tags && !capacity && !assignedTags) {
            return '';
        }
        return [name, tags, assignedTags, capacity].join('|');
    }

    saveExternalConfig = (params) => {
        const newParams = {...this.state.params, ...params};
        this.setState({params: newParams});
        if (this.props.setConfig) {
            this.props.setConfig(newParams);
        }
    };

    showActions = () => {
        return (
            <div id="sectionActions">
                {
                    //TODO: Перенести действия из модуля SprintPlanner
                    /*
                <Tumbler
                    view="default"
                    size="m"
                    checked={this.state.autoUpdate}
                    labelBefore="auto&nbsp;update"
                    id="autoUpdateTumbler"
                    onChange={() => this.setAutoUpdate(!this.state.autoUpdate)}
                />
                {this.state.autoUpdate ? (
                    <img src={btnUpdateGray} alt="Update" />
                ) : (
                    <img src={btnUpdateYellow} alt="Update" />
                )}
                
                <img src={btnAddTask} alt="Add task" />
            */
                }
                {
                    //TODO: Заменить инпут на селект, который будет наполняться спринтами из стартрека по названию очередей
                }
                <div id="mainInput">
                    <Textinput
                        size="s"
                        view="default"
                        value={this.state.inputAssignSprint}
                        title="Какой спринт планируем"
                        placeholder="Спринт №"
                        onChange={(e) => this.setState({inputAssignSprint: e.target.value})}
                        onKeyPress={(e) => (e && e.code && e.code === 'Enter' ? this.onApply() : console.log)}
                        onBlur={this.onApply}
                    />
                </div>
                {
                    //TODO: Сделать иконки кнопками - чтобы по ховеру и нажатию был интерактив
                }
                <Link to="#" onClick={() => this.setState({showTeams: true})}>
                    {/* <img src={btnTeams} alt="Edit teams" /> */}
                    <img src={btnTeams} alt="Teams" />
                </Link>
                <Link to="#" onClick={() => this.setState({showConfig: true})}>
                    <img src={btnSettings} alt="Settings" />
                </Link>
            </div>
        );
    };

    setBoard = (boardId) => {
        this.saveExternalConfig({board: boardId});
    };

    setAutoUpdate = (newState) => {
        this.setState({autoUpdate: newState});
    };

    configChange = (e) => this.setState({inputQuery: e.target.value});

    async componentDidMount() {
        if (this.state.params.query) {
            this.onApply();
        }
    }

    componentWillUnmount() {
        if (document.getElementById('main')) {
            document.getElementById('main').style.backgroundImage = ``;
            // style.backgroundImage = `url(${params.image})`;
        }
    }

    render() {
        const {params} = this.state;

        const style = {};
        if (params.image && document.getElementById('main')) {
            document.getElementById('main').style.backgroundImage = `url(${params.image})`;
            // style.backgroundImage = `url(${params.image})`;
        }

        return (
            <div className="app" style={style}>
                <div id="additionalMenu">
                    <div id="menuSpacer"></div>
                    {this.showActions()}
                </div>
                <div className="configurator-editor">
                    {this.state.showConfig && (
                        <Modal
                            theme="normal"
                            visible={this.state.showConfig}
                            onClose={() => this.setState({showConfig: false})}
                        >
                            <>
                                <div className="extra-settings">
                                    <div>
                                        <Text>Название доски:</Text>
                                        <Textinput
                                            size="s"
                                            view="default"
                                            value={this.state.inputBoardName}
                                            onChange={(e) => this.setState({inputBoardName: e.target.value})}
                                        />
                                    </div>
                                    <br />
                                    <div style={{display: 'flex'}}>
                                        <div>
                                            <Text>Очереди для новых задач:</Text>
                                            <Textinput
                                                size="s"
                                                view="default"
                                                value={this.state.inputNewTaskQueues}
                                                onChange={(e) => this.setState({inputNewTaskQueues: e.target.value})}
                                            />
                                        </div>
                                        &nbsp;&nbsp;&nbsp;
                                        <div>
                                            <Text>Теги по-умолчанию для новых задач:</Text>
                                            <Textinput
                                                size="s"
                                                view="default"
                                                value={this.state.inputAssignTags}
                                                onChange={(e) => this.setState({inputAssignTags: e.target.value})}
                                            />
                                        </div>
                                    </div>
                                    <br />
                                    <div>
                                        <Text>Показывать теги по фильтру:</Text>
                                        <Textinput
                                            size="s"
                                            view="default"
                                            value={this.state.inputShowTags}
                                            onChange={(e) => this.setState({inputShowTags: e.target.value})}
                                        />
                                    </div>
                                    <br />
                                    <Text>URL фоновой картинки:</Text>
                                    <Textinput
                                        size="s"
                                        view="default"
                                        value={this.state.inputCssBackgroundImage}
                                        onChange={(e) => this.setState({inputCssBackgroundImage: e.target.value})}
                                    />
                                    <br />
                                    <br />
                                    <Checkbox
                                        label="Сбрасывать спринт у задач, которые не берутся"
                                        size="m"
                                        view="default"
                                        checked={this.state.unsetSprint}
                                        onChange={() => this.setState({unsetSprint: !this.state.unsetSprint})}
                                    />
                                    <br />
                                    <br />
                                    <Checkbox
                                        label="Устанавливать тег кандидата в спринт для задач, которые не берутся "
                                        size="m"
                                        view="default"
                                        checked={this.state.setSprintCandidateTag}
                                        onChange={() =>
                                            this.setState({setSprintCandidateTag: !this.state.setSprintCandidateTag})
                                        }
                                    />
                                    {this.state.setSprintCandidateTag && (
                                        <>
                                            <br />
                                            <br />
                                            <Text>Тег кандидата в спринт:</Text>
                                            <Textinput
                                                size="s"
                                                view="default"
                                                value={this.state.sprintCandidateTag}
                                                onChange={(e) => this.setState({sprintCandidateTag: e.target.value})}
                                            />
                                        </>
                                    )}
                                    <br />
                                    <br />
                                    <Checkbox
                                        label="Не показывать распределение SP по людям"
                                        size="m"
                                        view="default"
                                        checked={this.state.hideAssigneeTotals}
                                        onChange={() =>
                                            this.setState({hideAssigneeTotals: !this.state.hideAssigneeTotals})
                                        }
                                    />
                                    <br />
                                    <br />
                                    <Checkbox
                                        label="Выводить вес"
                                        size="m"
                                        view="default"
                                        checked={this.state.showWeight}
                                        onChange={() => this.setState({showWeight: !this.state.showWeight})}
                                    />
                                    <br />
                                    <br />
                                    <Checkbox
                                        label="Открывать без историй"
                                        size="m"
                                        view="default"
                                        checked={this.state.withoutStories}
                                        onChange={() => this.setState({withoutStories: !this.state.withoutStories})}
                                    />
                                    <br />
                                    <br />
                                    <Checkbox
                                        label="Выгружать в тикет"
                                        size="m"
                                        view="default"
                                        checked={this.state.exportToTicket}
                                        onChange={() => this.setState({exportToTicket: !this.state.exportToTicket})}
                                    />
                                    {this.state.exportToTicket && (
                                        <>
                                            <br />
                                            <br />
                                            <Text>Номер тикета:</Text>
                                            <Textinput
                                                size="s"
                                                view="default"
                                                value={this.state.exportTicket}
                                                onChange={(e) => this.setState({exportTicket: e.target.value})}
                                            />
                                        </>
                                    )}
                                </div>
                            </>
                            <div className="modal-footer">
                                <Button
                                    view="action"
                                    size="s"
                                    onClick={() => {
                                        this.setState({showConfig: false});
                                        this.onApply();
                                    }}
                                >
                                    Применить
                                </Button>
                            </div>
                        </Modal>
                    )}

                    {this.state.showTeams && (
                        <Modal
                            theme="normal"
                            visible={this.state.showTeams}
                            onClose={() => this.setState({showTeams: false})}
                        >
                            <>
                                <div className="extra-settings">
                                    <div className="configurator-teams">
                                        <TeamConfig
                                            teamKey="1"
                                            teamsConfig={this.state.teams}
                                            onChange={(config) => this.setState({teams: config})}
                                        />
                                        <TeamConfig
                                            teamKey="2"
                                            teamsConfig={this.state.teams}
                                            onChange={(config) => this.setState({teams: config})}
                                        />
                                        <TeamConfig
                                            teamKey="3"
                                            teamsConfig={this.state.teams}
                                            onChange={(config) => this.setState({teams: config})}
                                        />
                                        <TeamConfig
                                            teamKey="4"
                                            teamsConfig={this.state.teams}
                                            onChange={(config) => this.setState({teams: config})}
                                        />
                                    </div>
                                </div>
                            </>
                            <div className="modal-footer">
                                <Button
                                    view="action"
                                    size="s"
                                    onClick={() => {
                                        this.setState({showTeams: false});
                                        this.onApply();
                                    }}
                                >
                                    Применить
                                </Button>
                            </div>
                        </Modal>
                    )}
                </div>

                {this.state.plannerParams && (
                    <SprintPlanner
                        {...this.state.plannerParams}
                        autoUpdate={this.state.autoUpdate}
                        configChange={this.configChange}
                        inputQuery={this.state.inputQuery}
                        onApply={this.onApply}
                    />
                )}
            </div>
        );
    }
}
