import {TeamStat} from "../TeamStat/TeamStat";
import {TaskList} from "../TaskList/TaskList";
import React from "react";

export const TasksGroup = ({title, tasks, teamStat, onAssignTask, onEditSave, showWeight, showTags, allocationParents, onOpenTask}) => {
    return (
        <div className='group'>
            <div className='group-header'>
                <span className='group-title'>
                    [<TeamStat teamStat={teamStat} />] {title}
                </span>
            </div>
            <TaskList tasks={tasks} taskLineProps={{
                onAssignTask,
                onEditSave,
                showWeight,
                showTags,
                allocationParents,
                onOpenTask
            }}/>
        </div>
    )
};
