import React, {useState} from "react";
import {TeamStat} from "../TeamStat/TeamStat";
import {Link} from "@yandex-lego/components/Link/desktop/bundle";
import {taskUrl} from "../../startrek";
import {Button} from "@yandex-lego/components/Button/desktop/bundle";
import {TaskEditor} from "../TaskEditor/TaskEditor";
import {TaskList} from "../TaskList/TaskList";

export const UserStory = ({parent, parentTask, tasks, teamStat, onAssignTask, onEditSave, onEditParentSave, showWeight, showTags, onOpenTask}) => {
    const {display, key} = parent;
    const [editMode, setEditMode] = useState(false);

    const onEditStorySave = (task, newProps) => {
        onEditParentSave(task, newProps);
        setEditMode(false);
    }

    return (
        <div>
            <div className='story'>
                <div className='story-header'>
                <span className='story-title'>
                    [<TeamStat teamStat={teamStat} />]
                    &nbsp;
                    {parentTask ? parentTask.summary : display}
                </span>
                    <Link target="_blank" size="xs" theme="ghost" href={taskUrl(key)}>
                        {parent.key}
                    </Link>
                    &nbsp;|&nbsp;
                    Вес: {parentTask ? ('weight' in parentTask ? parentTask.weight : 'не задан') : 'не задан'}
                    {parentTask &&
                    <>
                        &nbsp;&nbsp;
                        <Button view="clear" size="xs" onClick={() => setEditMode(!editMode)}>
                            редактировать
                        </Button>
                    </>
                    }
                    &nbsp;
                    {parentTask && editMode &&
                    <TaskEditor storyMode task={parentTask} onSave={onEditStorySave} onCancel={() => setEditMode(false)}/>
                    }
                </div>
                <TaskList tasks={tasks} taskLineProps={{
                    onAssignTask,
                    onEditSave,
                    showWeight,
                    showTags,
                    onOpenTask
                }}/>
            </div>
        </div>
    )
};

