import { inc, taskCompareFn } from "../../lib/functions";

export const processTasks = (tasks, groupBy = "stories", parents = {}) => {
    const totals = {};
    const groups = {};
    const stories = {};
    const tagStat = {};
    const assigneeTotals = {};
    const assigneeDict = {};

    for (let task of tasks) {
        const team = task.team;
        const { storyPoints = 0 } = task;

        if (team) {
            inc(totals, team, storyPoints);
            if (task.assignee) {
                inc(assigneeTotals, task.assignee.id, storyPoints);
                assigneeDict[task.assignee.id] = task.assignee;
            } else {
                inc(assigneeTotals, "", storyPoints);
                assigneeDict[""] = null;
            }
        }

        if (task.tags) {
            for (let tag of task.tags) {
                if (!tagStat[tag]) {
                    tagStat[tag] = 0;
                }
                tagStat[tag] += 1;
            }
        }

        if (groupBy === "components" && task.components) {
            const groupId = task.components.map((c) => c.display).join(", ");
            if (!groups[groupId]) {
                groups[groupId] = {
                    title: "Компонент: " + groupId,
                    tasks: [],
                    teamStat: {},
                };
            }
            groups[groupId].tasks.push(task);
            team && inc(groups[groupId].teamStat, team, storyPoints);
        } else {
            if (task.type && task.type.key) {
                if (!task.parent) {
                    const groupId = task.type.key;
                    if (!groups[groupId]) {
                        groups[groupId] = {
                            title: "Тип: " + task.type.display,
                            tasks: [],
                            teamStat: {},
                        };
                    }
                    groups[groupId].tasks.push(task);
                    team && inc(groups[groupId].teamStat, team, storyPoints);
                } else {
                    const parentId = task.parent.key;
                    if (!stories[parentId]) {
                        stories[parentId] = {
                            parent: task.parent,
                            parentTask: parents[task.parent.key],
                            tasks: [],
                            teamStat: {},
                        };
                    }
                    stories[parentId].tasks.push(task);
                    team && inc(stories[parentId].teamStat, team, storyPoints);
                }
            }
        }
    }

    const totalsArr = [];
    for (let team in totals) {
        totalsArr.push({ team, storyPoints: totals[team] });
    }

    const tagsArr = [];
    for (let tag in tagStat) {
        tagsArr.push({ tag, count: tagStat[tag] });
    }

    for (let g of Object.values(groups)) {
        g.tasks.sort(taskCompareFn);
    }

    for (let s of Object.values(stories)) {
        s.tasks.sort(taskCompareFn);
    }

    const assigneeTotalsArr = [];
    for (let assigneeId of Object.keys(assigneeTotals).sort()) {
        assigneeTotalsArr.push({
            assignee: assigneeDict[assigneeId],
            total: assigneeTotals[assigneeId],
        });
    }

    totalsArr.sort((t1, t2) => (t1.team < t2.team ? -1 : 1));

    return {
        totals: totalsArr,
        assigneeTotals: assigneeTotalsArr,
        groups: Object.values(groups).sort((g1, g2) => (g1.title < g2.title ? -1 : 1)),
        stories: Object.values(stories).sort((s1, s2) => {
            const k1 = s1.parent.key;
            const k2 = s2.parent.key;
            const n1 = s1.parent.display;
            const n2 = s2.parent.display;
            const w1 = parents[k1] ? parents[k1].weight || 0 : 0;
            const w2 = parents[k2] ? parents[k2].weight || 0 : 0;
            if (w1 === w2) {
                return n1 < n2 ? -1 : 1;
            }
            return w1 > w2 ? -1 : 1;
        }),
        tags: tagsArr,
    };
};
