const getTaskMd = (task) => {
    const {key, summary, team} = task;
    const teamIns = team ? '[ ' + team + ' ]' : '';
    const spStr = '[' + (task.storyPoints === undefined ?  '?' : task.storyPoints) + ' sp]';
    return `- ${teamIns} ${spStr} ${summary} ${key}`;
};

const getTasksMd = (tasks) => tasks.map(getTaskMd).join("\n");

export const createMd = ({totals, groups, stories}) => {
    const statOut = [];
    statOut[statOut.length] = '#|';
    statOut[statOut.length] = '|| Team | Story Points Plan ||';
    statOut[statOut.length] = totals.map(({team, storyPoints}) => `|| **${team}** | **${storyPoints}**||`).join('\n');
    statOut[statOut.length] = '|#';

    const out = [];
    out[out.length] = '====План';
    out[out.length] = statOut.join('\n');
    if (stories.length) {
        out[out.length] = '====Истории\n' + stories.map(
            ({parent, tasks}) => `1. ((${parent.key} ${parent.display}))`
        ).join('\n');
    }
    out[out.length] = groups.map(({title, tasks}) => '====' + title + '\n' + getTasksMd(tasks) + '\n').join('\n');
    out[out.length] = stories.map(({parent, tasks}) =>
        `**((${parent.key} ${parent.display}))**\n` + getTasksMd(tasks) + '\n').join('\n');
    return out.join('\n\n');
}
