import React from 'react';
import {Textinput} from "@yandex-lego/components/Textinput/desktop/bundle";
import {Suggest} from "../Suggest/Suggest";
import {Button} from "@yandex-lego/components/Button/desktop/bundle";
import {Select} from "@yandex-lego/components/Select/desktop/bundle";
import {Textarea} from "@yandex-lego/components/Textarea/desktop/bundle";
import {getTagsArray} from "../../lib/functions";

export class TaskEditor extends React.PureComponent {
    constructor(props) {
        super(props);
        console.log('TaskEditor: ', props);
        const {task = {}} = props;
        let queue;
        if (task.queue) {
            queue = task.queue.key;
        } else {
            if (!props.queues.length) {
                console.log('TaskEditor - empty queues for new task');
            }
            queue = props.queues[0];
        }

        this.state = {
            queue,
            assignee: task.assignee,
            summary: task.summary || '',
            weight: task.weight || '',
            storyPoints: task.storyPoints || '',
            tags: (task.tags || []).join(', '),
            editDescription: false,
            description: task.description || ''
        }
    }

    onSave = () => {
        const newProps = {
            summary: this.state.summary,
            weight: +this.state.weight,
        }
        if (!this.props.storyMode) {
            newProps.storyPoints = this.state.storyPoints === '' ? null : +this.state.storyPoints;
            newProps.tags = getTagsArray(this.state.tags) || [];
            newProps.assignee = this.state.assignee;
        }
        if (!this.props.task || !this.props.task.key) {
            newProps.queue = {key: this.state.queue};
        }
        if (this.state.editDescription) {
            newProps.description = this.state.description;
        }
        if (this.state.allocationParent) {
            newProps.parent = {key: this.state.allocationParent};
        }
        console.log('TaskEditor onSave generated new props', newProps);
        this.props.onSave && this.props.onSave(this.props.task, newProps, this.state.allocationParent);
    }

    componentDidMount() {
        this.input.childNodes[0].focus();
        //console.log(this.input);
        //this.input.focus();
    }

    onCancel = () => {
        this.props.onCancel && this.props.onCancel();
    }

    onInputKeyPress = (e) => {
        if (e.which === 13) {
            this.onSave();
        }
    }

    onKeyDown = (e) => {
        if (e.which === 27) {
            this.onCancel();
        }
    }

    onChangeParent = (e) => {
        this.setState({
            allocationParent: e.target.value
        });
    }


    render() {
        return <div className='task-editor' onKeyDown={this.onKeyDown}>
            <Textinput
                className='input-m'
                size="s"
                view="default"
                value={this.state.summary}
                innerRef={(el) => this.input = el}
                placeholder='Название задачи'
                onChange={(e) => this.setState({summary: e.target.value})}
                onKeyPress={this.onInputKeyPress}
            />
            &nbsp;
            {!this.props.storyMode &&
            <>
                Story Points:&nbsp;
                <Textinput
                    className='input-xs'
                    size="s"
                    view="default"
                    value={this.state.storyPoints}
                    onChange={(e) => this.setState({storyPoints: e.target.value})}
                    onKeyPress={this.onInputKeyPress}
                />
            </>
            }
            &nbsp;
            Вес:&nbsp;
            <Textinput
                className='input-xs'
                size="s"
                view="default"
                value={this.state.weight}
                onChange={(e) => this.setState({weight: e.target.value})}
                onKeyPress={this.onInputKeyPress}
            />
            <br /><br />
            {(!this.props.task || !this.props.task.key) &&
            <>
                Очередь:&nbsp;
                <Select
                    size="s"
                    theme='normal'
                    onChange={(e) => this.setState({queue: e.target.value})}
                    value={this.state.queue}
                    options={this.props.queues.map(q => ({value: q, content: q}))}
                />
                &nbsp;&nbsp;
            </>
            }
            {!this.props.storyMode &&
            <>
                Теги:&nbsp;
                <Textinput
                    className='input'
                    size="s"
                    view="default"
                    value={this.state.tags}
                    onChange={(e) => this.setState({tags: e.target.value})}
                    onKeyPress={this.onInputKeyPress}
                />
                &nbsp;&nbsp;
                <Suggest
                    label='Исполнитель'
                    resource='users'
                    displayClass='login'
                    value={this.state.assignee}
                    onChange={(val) => {
                        console.log('onchange: ', val);
                        this.setState({assignee: val})
                    }}
                />
                <br /><br />
            </>
            }
            {this.props.allocationParents && this.props.allocationParents.length > 0 &&
            <>
                История:&nbsp;
                <Select
                    size="s"
                    theme='normal'
                    onChange={this.onChangeParent}
                    value={this.state.allocationParent}
                    options={this.props.allocationParents.map(({key, label}) => ({value: key, content: label}))}
                />
                <br /><br />
            </>
            }
            <Button view="clear" size="xs"
                    onClick={() => this.setState({editDescription: !this.state.editDescription})}>
                {this.state.editDescription ? '▼ Скрыть описание' : '▶ Показать описание'}
            </Button>
            <br/>
            {this.state.editDescription &&
            <>
                <br />
                <Textarea
                    className='textarea-m'
                    size="m"
                    view="default"
                    value={this.state.description}
                    onChange={(event) => this.setState({description: event.target.value})}
                />
                <br />
            </>
            }
            <br />
            <div className='task-editor-buttons'>
                <Button view="action" size="s" onClick={this.onSave}>
                    Сохранить
                </Button>
                &nbsp;&nbsp;&nbsp;
                <Button view="clear" size="xs" onClick={this.onCancel}>
                    Отменить
                </Button>
            </div>
        </div>;
    }
}
