import React from 'react';
import PropTypes from 'prop-types';
import './style.css';

export class TaskFrame extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            key: this.props.taskKey,
            tetrisVisible: true,
        }
        this.iframeRef = React.createRef();
    }

    onMessage = (e) => {
        if (e.source !== this.iframeRef.current.contentWindow) {
            return;
        }
        console.log('my message: ', e);
        if (e.data.issueCardAction && e.data.issueCardAction === 'open') {
            this.setState({
                key: e.data.key,
                tetrisVisible: true,
            });
            return;
        }
        if (typeof e.data === 'string' && e.data.length > 0 && e.data[0] === '{') {
            const dataObj = JSON.parse(e.data);
            console.log('dataObj', dataObj);
            if (dataObj.data && dataObj.data.type === 'initToParent') {
                this.setState({
                    tetrisVisible: false,
                })
            }
        }
    }

    componentDidUpdate(prevProps, prevState, snapshot) {
        if (this.props.taskKey !== prevProps.taskKey) {
            this.setState({
                key: this.props.taskKey,
                tetrisVisible: true,
            })
        }
    }

    onLoad = (e) => {
        console.log('iframe onload');
        this.setState({
            tetrisVisible: false,
        })
    }

    componentDidMount() {
        window.addEventListener('message', this.onMessage);
        //this.iframeRef.current
    }

    componentWillUnmount() {
        window.removeEventListener('message', this.onMessage);
    }

    render() {
        return (
            <div className='task-frame'>
                <iframe
                    className="task-frame-frame"
                    src={`https://st.yandex-team.ru/issueCard/${this.state.key}?source_parent=ticket`}
                    onLoad={this.onLoad}
                    title='Embeded startrek task'
                    ref={this.iframeRef}
                />
                {this.state.tetrisVisible &&
                    <div className='task-frame-tetris' />
                }
            </div>
        )
    }
}

TaskFrame.propTypes = {
    taskKey: PropTypes.string.isRequired,
};
