import React, {useState} from 'react';
import {Modal} from '@yandex-lego/components/Modal/desktop/bundle';
import {Link} from '@yandex-lego/components/Link/desktop/bundle';

import {HintLink} from '../HintLink/HintLink';
import {TaskLine} from '../TaskLine/TaskLine';
import {ksort} from '../../lib/functions';
import {taskUrl} from '../../startrek';

import './TasksRef.css';


export const TasksRef = ({
                             tasks,
                             taskDict,
                             children,
                             groupByParent = false,
                             title = '',
                             hintLinkClassName = '',
                         }) => {

    const [modalVisible, setModalVisible] = useState(false);
    if (!tasks.length) {
        return (
            <HintLink
                className={hintLinkClassName}
                onClick={() => setModalVisible(true)}
                disabled
            >
                {children}
            </HintLink>
        );
    }
    const groups = {};
    for (const taskKey of tasks) {
        const task = taskDict[taskKey];
        const group = groupByParent && task.parent ?
            task.parent.key :
            (task.group || 'Несгруппированные задачи');

        if (!groups[group]) {
            groups[group] = {
                name: group,
                parentTask: task.parent,
                tasks: [],
            };
        }
        groups[group].tasks.push(task);
    }
    ksort(groups);

    const queryLink = encodeURI(`https://st.yandex-team.ru/issues/?_q=Key: ${tasks.join()}`);

    return (
        <>
            <HintLink
                className={hintLinkClassName}
                onClick={() => setModalVisible(true)}
            >
                {children}
            </HintLink>
            <Modal
                theme='normal'
                visible={modalVisible}
                onClose={() => setModalVisible(false)}
            >
                <div className='tasks-modal'>
                    <div className={'tasks-ref__header'}>
                        <h3>{title}</h3>
                        <Link
                            target='_blank'
                            size='xs'
                            theme='normal'
                            href={queryLink}
                        >
                            Задачи в трекере
                        </Link>
                    </div>
                    {Object.values(groups).map(g => (
                        <div key={g.name}>
                            <div>
                                <b>{g.name}</b>
                                {
                                    groupByParent && g.parentTask &&
                                    <Link
                                        className='group-link'
                                        target="_blank"
                                        size="s"
                                        view="default"
                                        href={taskUrl(g.parentTask.key)}
                                    >
                                        {g.parentTask.display}
                                    </Link>
                                }
                            </div>
                            {g.tasks.map(task =>
                                <TaskLine
                                    key={task.key}
                                    mode='analyze'
                                    task={task}
                                    canEdit={false}
                                    showWeight={false}
                                    showType={true}
                                    useOriginalStoryPoints={true}
                                />,
                            )}
                            <br />
                        </div>
                    ))}
                </div>
            </Modal>
        </>
    );
};
