import React from "react";
import {Text} from "@yandex-lego/components/Text/desktop/bundle";
import {Textinput} from "@yandex-lego/components/Textinput/desktop/bundle";

export const TeamConfig = ({teamKey, teamsConfig, onChange}) => {
    const {name, tags, assignedTags, capacity} = teamsConfig[teamKey];

    const change = (obj) => {
        onChange({
            ...teamsConfig,
            [teamKey]: {
                ...teamsConfig[teamKey],
                ...obj
            }
        });
    }

    return (
        <div className='teamConfig'>
            <Text className='teamConfig-title'>
                Команда {teamKey}
            </Text>
            <div>
                <Text>Название:</Text>
                <Textinput size="s"  view="default"  value={name} onChange={(e) => change({name: e.target.value})} />
            </div>
            <br/>
            <div>
                <Text>Теги команды:</Text>
                <Textinput size="s"  view="default"  value={tags} onChange={(e) => change({tags: e.target.value})} />
            </div>
            <br/>
            <div>
                <Text>Теги взятых задач:</Text>
                <Textinput size="s"  view="default"  value={assignedTags} onChange={(e) => change({assignedTags: e.target.value})} />
            </div>
            <br/>
            <div>
                <Text>Капасити SP:</Text>
                <Textinput size="s"  view="default"  value={capacity} onChange={(e) => change({capacity: e.target.value})} />
            </div>
        </div>
    );
};
