import React from "react";
import { Spin } from "@yandex-lego/components/Spin/desktop/bundle";

const trackerTicketMask = "^[a-zA-Z]+-[0-9]+$";

const Links = ({ ticket, tree }) => {
    let result, treeMessage;
    if (!new RegExp(trackerTicketMask).test(ticket)) {
        treeMessage = <div>Введите номер тикета в поле выше</div>;
    } else {
        treeMessage = tree ? (
            <br />
        ) : (
            <div id="FetchDataSpinner">
                <Spin progress view="default" size="m" />
                <span className="red"> Подождите</span> - Дерево строится. Показываю подзадачи первого уровня..
            </div>
        );
    }
    result = (
        <div>
            <div>{tree ? "" : ""}</div>
            <div>{treeMessage}</div>
        </div>
    );
    return result;
};

export default Links;
