import WebClient from './WebClient';

let isLocalhost = false; // Да, она нужна только для тестов, но как же утомительно каждый раз деплоить на гитхаб, чтобы проверить работу

const isNode = typeof window === 'undefined';
let BASE_URL: string;
if (isNode) {
    BASE_URL = 'https://st-api.yandex-team.ru';
} else {
    //browser
    isLocalhost = window && window.location && window.location.hostname === 'localhost';
    BASE_URL = isLocalhost ? '/' : 'https://st-api.yandex-team.ru';
}

const getPath = (text: string): any =>
    !isLocalhost
        ? {
              get: `/v2/issues/${text}?timestamp=${new Date().getTime()}`, // timestamp to prevent cache in browser
              getLinks: `/v2/issues/${text}/links?timestamp=${new Date().getTime()}`,
              getQuery: `/v2/issues?${text}`,
              update: `/v2/issues/${text}`,
          }
        : {
              get: `/test/${text}.json`,
              getLinks: `/test/${text} links.json`,
              getQuery: `/test/?${text}`,
              update: `/v2/issues/${text}`,
          };

export default class StartrekClient {
    baseUrl: string;
    handler: any;

    constructor() {
        this.baseUrl = BASE_URL;
        this.handler = new WebClient(BASE_URL);
    }

    getLinks(ticket: string): Promise<any[]> {
        return this.handler.get(getPath(ticket).getLinks);
    }

    get(ticketOrQuery: string | object): Promise<any> {
        let path = '';
        if (typeof ticketOrQuery === 'string') {
            const ticket = ticketOrQuery;
            path = getPath(ticket).get;
        } else if (typeof ticketOrQuery === 'object') {
            let queryParams = '';
            for (const prop in ticketOrQuery) {
                queryParams += queryParams ? '' : '&';
                // @ts-ignore
                queryParams += `${prop}=${ticketOrQuery[prop]}`;
            }
            path = getPath(queryParams).getQuery;
        } else {
            throw new Error(
                '* ERROR in get in StartrekClient: Function "get" in st-client.js accepts only strings and objects. Pardon ',
            );
        }
        return this.handler.get(path);
    }

    update(ticket: string, textOrObj: string | object): Promise<string> {
        let dataObj;
        if (!ticket || !(typeof ticket === 'string'))
            throw new Error('* ERROR: Can not update ticket - ticket key is not defined');
        if (!textOrObj) throw new Error('* ERROR: Can not update ticket - data object is not defined');
        if (typeof textOrObj === 'string') dataObj = {description: textOrObj};
        else if (typeof textOrObj === 'object') dataObj = textOrObj;
        else
            throw new Error(
                '* ERROR in update in StartrekClient: Can not update ticket - data object shall be string or object with description property',
            );
        return this.handler.patch(getPath(ticket).update, dataObj);
    }
}
