import {BudgetClass} from '../types';
import {formatBudgetNumber} from '../commonFunctions';

export const budgetToMarkdown = (budget: BudgetClass): string => {
    let result = '';

    if (!budget.teams || budget.teams.length === 0) return result;
    result += '  #|\n';
    result += '  || **Команда** | **Потрачено SP** | **Оценено SP** | **Не оценено шт.** ||\n';
    let team, isSubjectForPrinting;
    for (let i = 0; i < budget.teams.length; i++) {
        team = budget.teams[i];
        isSubjectForPrinting =
            (budget.teamFilter.length === 0 || budget.teamFilter.includes(team.name)) &&
            (team.estimatedSP || team.spentSP || team.numEndTasksWithoutEstimation);
        if (isSubjectForPrinting) {
            result += `  || ${team.name}`;
            result += `  |  ${formatBudgetNumber(team.spentSP)}`;
            result += `  |  ${formatBudgetNumber(team.estimatedSP)} `;
            result += `  |  ${formatBudgetNumber(team.numEndTasksWithoutEstimation)} ||\n`;
        }
    }
    result += `  |#\n`;

    result = `  1. Потрачено: ${formatBudgetNumber(budget.totalSpentSP)} / Оценено: ${formatBudgetNumber(
        budget.totalEstimatedSP,
    )} \n${result}`;
    result = `  1. Изначальный бюджет в SP: ${formatBudgetNumber(budget.originalSP)}\n${result}`;
    result = `\n=== Показатели бюджета \n${result}`;

    return result;
};
