import {BudgetClass} from '../types';
import {formatBudgetNumber} from '../commonFunctions';

export const budgetToText = (budget: BudgetClass): string => {
    let result = '';

    if (!budget.teams || budget.teams.length === 0) return result;
    let team, isSubjectForPrinting;
    for (let i = 0; i < budget.teams.length; i++) {
        team = budget.teams[i];
        isSubjectForPrinting =
            (budget.teamFilter.length === 0 || budget.teamFilter.includes(team.name)) &&
            (team.estimatedSP || team.spentSP || team.numEndTasksWithoutEstimation);
        if (isSubjectForPrinting) {
            result += `     * ${team.name}:`;
            result += ` Потрачено: ${formatBudgetNumber(team.spentSP)};`;
            result += ` Оценено: ${formatBudgetNumber(team.estimatedSP)};`;
            result += ` Задач не оценено: ${formatBudgetNumber(team.numEndTasksWithoutEstimation)}\n`;
        }
    }

    result = `  2. Потрачено: ${formatBudgetNumber(budget.totalSpentSP)} / Оценено: ${formatBudgetNumber(
        budget.totalEstimatedSP,
    )} \n${result}`;
    result = `  1. Изначальный бюджет в SP: ${formatBudgetNumber(budget.originalSP)}\n${result}`;
    result = `\nПоказатели бюджета \n${result}`;

    return result;
};
