import {TreeNode} from '../types';
import {concat, flip} from 'ramda';

/**
 * @param {TreeNode} param0
 * @returns boolean
 */
export const isFinished = ({isFinished}: TreeNode): boolean | undefined => isFinished;

/**
 * @param {TreeNode} param0
 * @returns boolean
 */
export const hasChildren = ({children}: TreeNode): boolean => (children && children.length > 0 ? true : false);

/**
 * Фабрика обёрток вида XX+text+XX
 * @param {string} token
 * @returns {function(string):string}
 */
export const decorateWith = (token: string) => (text: string): string => {
    return `${token}${text}${token}`;
};

/**
 * Ничего не делает.
 * (не взял identity из рамды, ибо она смущает типы)
 *
 * @param {string} x
 */
export const noop = (x: any): any => x;

/** добавляет строку в конец */
export const add = flip(concat);

/** добавляет пробел между маркером списка и текстом */
export const addInitialSpace = (text: string): string => ' ' + text;

const getQueue = (key: string): string => key.substr(0, key.indexOf('-'));
const getNumInQueue = (key: string): string => key.substr(key.indexOf('-') + 1, key.length);
export const compareNodesForSort = (a: TreeNode, b: TreeNode): number => {
    let result = 1;
    result = a.isFinished && !b.isFinished ? -1 : 1;
    if (a.isFinished === b.isFinished) {
        result = a.id < b.id ? -1 : 1;
        if (a.id && b.id && getQueue(`${a.id}`) === getQueue(`${b.id}`))
            result = +getNumInQueue(`${a.id}`) < +getNumInQueue(`${b.id}`) ? -1 : 1;
    }
    return result;
};
