import {TreeNode} from '../types';
import {
    isFinished,
    add,
    compareNodesForSort,
} from './formattersCommon';
import {compose} from 'ramda';

/** закрытие тикеты с детьми сворачивает */
// const collapseNode = concat('');


// main formatting functions

const getKey = (node: TreeNode): string => (isFinished(node) ? `((${node.id}));` : `${node.id};`);
const addTitle = (node: TreeNode): any => (node.title ? add(`${node.title};`) : add(`;`));
const addStatus = (node: TreeNode): any => node.status && node.status.display ? add(`${node.status.display};`) : add(`;`);
const addResolution = (node: TreeNode): any => (node.resolution && node.resolution.key? add(`${node.resolution.key};`):add(`;`) );
const addResolvedDate = (node: TreeNode): any => (node.resolvedAt ? add(`${node.resolvedAt};`):add(`;`) );
const addSP = (node: TreeNode): any => (node.storyPoints ? add(`${node.storyPoints};`) : add(`;`));

const addTags = (node: TreeNode): string => (node.tags ? `${node.tags};` : `;`);
const addAssignee= (node: TreeNode): string => (node.assignee ? `${node.assignee};` : `;`);


const addSprint = (node: TreeNode): any => {
    if (node.sprint && node.sprint.length) {
        let result = '';
        for (let k = 0; k < node.sprint.length; k++) {
            if (k > 0) result += ', ';
            result += node.sprint[k].display;
        }
        return add(`${result};`);
    } else return add(`;`);
};


/**
 * Вывод узла в виде markdown
 * @param {TreeNode} node
 * @returns string
 */
export const getLineForNode = (node: TreeNode): string => {
    let result = '';
    const decorate = compose(
        addSprint(node),
        addSP(node),
        addResolvedDate(node),
        addResolution(node),
        addStatus(node),
        addTitle(node),
    );
    //@ts-ignore
    result += decorate(getKey(node));
    result += addTags(node);
    result += addAssignee(node);
    return result;
};

const getPrefix = (prefix: string, i?: number): string => prefix? `${prefix}-${(i || 0) + 1}`:` ${(i || 0) + 1}`;

/**
 * Вывод узла и его детей в виде markdown
 * @param {TreeNode} node
 * @param {string} incomingPrefix
 * @returns string
 */
const formatRecursively = (node: TreeNode, incomingPrefix: string): string => {
    let result = '';
    const currentFormatterPrefix='';
    if (node.children && node.children.length) {
        const prefix = currentFormatterPrefix + incomingPrefix;
        const children = node.children.sort((a: TreeNode, b: TreeNode) => compareNodesForSort(a, b));
        for (let i = 0; i < children.length; i++) {
            const child = children[i];
            const tmpPrefix = getPrefix(prefix, i);
            result += tmpPrefix +';'+ getLineForNode(child) + '\n';
            if (child.children && child.children.length > 0) {
                result += formatRecursively(child, tmpPrefix);
            }
        }
    }
    return result;
};

/**
 * Компиляция полного текста в виде markdown
 * @param {TreeNode} node
 * @returns string
 */
export const nodeToCSV = (node: TreeNode): any => {
    return `${node.id} ${node.title}\n`+
            ` #;Ticket;Title;Status;Resolution;Resolved Date;SP;Sprint;Tags;Assignee\n`+
            `${formatRecursively(node, '')}`;
};
