import {nodeToMarkdown} from './nodeToMarkdown';
import {nodeToMarkdown2} from './nodeToMarkdown2';
import {nodeToText} from './nodeToText';
import {nodeToCSV} from './nodeToCSV';
import {budgetToMarkdown} from './budgetToMarkdown';
import {budgetToText} from './budgetToText';
import {FormatterSelector} from '../types';

const formatNodeDefinition: FormatterSelector = {
    markdown: nodeToMarkdown,
    markdown2: nodeToMarkdown2,
    html: nodeToText,
    text: nodeToText,
    csv: nodeToCSV,
    default: nodeToText,
};
//@ts-ignore
export const nodeFormatter = (formatter: string): Function => formatNodeDefinition[formatter];

const formatBudgetDefinition: FormatterSelector = {
    markdown: budgetToMarkdown,
    markdown2: budgetToMarkdown,
    html: budgetToText,
    text: budgetToText,
    csv: budgetToText,
    default: budgetToText,
};
//@ts-ignore
export const budgetFormatter = (formatter: string): Function => formatBudgetDefinition[formatter];
