/* eslint-disable no-undef */
import {mergeDeepRight} from 'ramda';

import {getLineForNode} from '../nodeToMarkdown';

const createNode = (node = {}) =>
    /** @type TreeNode */
    mergeDeepRight(
        {
            id: 'fake-key',
            parentId: '',
            children: [],
            isFinished: false,
            nest: 0,
            status: {self: 'self', id: 'id', key: 'key', display: 'fake-status'},
            title: '',
            dependsOn: [],
            sprint: [],
            isSummary: false,
            storyPoints: 0,
            startDate: undefined,
            originalStoryPoints: 0,
        },
        node,
    );

describe('getLineForNode', () => {
    it('зачеркивает закрытые тикеты', () => {
        const node = createNode({isFinished: true});
        const actual = getLineForNode(node);

        expect(actual.startsWith(' --')).toBe(true);
        expect(actual.endsWith('--')).toBe(true);
    });
    it('жирнит тикеты с детьми', () => {
        const node = createNode({children: [createNode()]});
        const actual = getLineForNode(node);

        expect(actual.startsWith(' **')).toBe(true);
        expect(actual.endsWith('**')).toBe(true);
    });
    it('закрытие тикеты с детьми сворачивает', () => {
        const node = createNode({isFinished: true, children: [createNode()]});
        const actual = getLineForNode(node);

        expect(actual.startsWith('+ ')).toBe(true);
    });
    it('закрытие тикеты с детьми сворачивает, жирнит и зачеркивает - именно в таком порядке', () => {
        const node = createNode({isFinished: true, children: [createNode()]});
        const actual = getLineForNode(node);

        expect(actual.startsWith('+ --**')).toBe(true);
    });
    it('добавляет спринт', () => {
        const node = createNode({sprint: [{self: 'self', id: 'id', key: 'key', display: 'fake-sprint'}]});
        const actual = getLineForNode(node);

        expect(actual.endsWith('[sprint:fake-sprint]')).toBe(true);
    });
    it('добавляет SP', () => {
        const node = createNode({storyPoints: 7});
        const actual = getLineForNode(node);

        expect(actual.endsWith('[7SP]')).toBe(true);
    });
    describe('все вместе', () => {
        it('закрытый', () => {
            const node = createNode({
                isFinished: true,
                children: [createNode()],
                title: 'fake-title',
                status: {self: 'self', id: 'id', key: 'key', display: 'fake-status'},
                sprint: [{self: 'self', id: 'id', key: 'key', display: 'fake-sprint'}],
                storyPoints: 13,
            });
            const actual = getLineForNode(node);
            const expected = '+ --**((fake-key)): fake-title [fake-status] [13SP] [sprint:fake-sprint]**--';

            expect(actual).toBe(expected);
        });
        it('незакрытый', () => {
            const node = createNode({
                isFinished: false,
                children: [createNode()],
                title: 'fake-title',
                status: {self: 'self', id: 'id', key: 'key', display: 'fake-status'},
                sprint: [{self: 'self', id: 'id', key: 'key', display: 'fake-sprint'}],
                storyPoints: 13,
            });
            const actual = getLineForNode(node);
            const expected = ' **fake-key: fake-title [fake-status] [13SP] [sprint:fake-sprint]**';

            expect(actual).toBe(expected);
        });
    });
});
