/******************************
 * Название: TreeBuilder
 * Описание: Функции для создания и наполнения объекта типа TreeNode
 * Автор: copytenz, май 2020
 *******************************/

// let settings = require('./infra/settings');

import StartrekClient from './StartrekClient';
import {logError, logDebug} from './commonFunctions';
import {Ticket, TreeNode} from './types';
const tracker = new StartrekClient();
const NEST_LIMIT = 10;

const mapTicket = (issue: any): Ticket => {
    const resultNode: Ticket = {
        id: issue.key,
        title: issue.summary || '',
        assignee: issue.assignee,
        status: issue.status,
        resolution: issue.resolution || undefined,
        sprint: issue.sprint ? issue.sprint : [],
        isFinished: issue.resolution ? true : false,
        originalStoryPoints: issue.originalStoryPoints || 0,
        storyPoints: issue.storyPoints,
        tags: issue.tags || [],
        resolvedAt: issue.resolvedAt || undefined
    };
    return resultNode;
};

const mapLink = async (parentId: string, nest: number, link: any): Promise<TreeNode> => {
    logDebug(link.object.key, nest);
    // eslint-disable-next-line @typescript-eslint/no-use-before-define
    const node = await dumpStructure(link.object.key, link.object.display, nest);
    return Object.assign(node, {parentId, nest});
};
//Основная функция - рекурсивно проходит через структуру тикетов и создаёт структуру дерева
const dumpStructure = async (ticketId: string, ticketTitle?: string, nest?: number): Promise<TreeNode> => {
    // eslint-disable-next-line prefer-const
    // let [ticketDetails, links] = await Promise.all([tracker.get(ticketId), tracker.getLinks(ticketId)]);
    const issueDetails = await tracker.get(ticketId);
    let ticketDetails: Ticket;
    if (issueDetails.key) ticketDetails = mapTicket(issueDetails);
    // In case tracker.get fails ticket
    else
        ticketDetails = {
            id: ticketId,
            title: ticketTitle,
        };
    const node: TreeNode = {
        ...ticketDetails,
        parentId: '',
        children: [],
    };

    nest = nest ? nest + 1 : 1;
    if (nest >= NEST_LIMIT) return node;

    let links = await tracker.getLinks(ticketId);
    if (links && links.length) {
        links = links.filter((link: any) => link.type.id === 'subtask' && link.direction === 'outward');
        try {
            node.children = await Promise.all(links.map(async (link: any) => await mapLink(ticketId, nest || 1, link)));
        } catch (err) {
            logError(err, 'dumpStructure in treeBuilder');
            // Если promise.all не сработал - то значит кто-то из деток недоступен. Тогда пойдём по старинке по одному, чтобы достать хоть что-то
            for (let i = 0; i < links.length; i++) node.children.push(await mapLink(ticketId, nest, links[i]));
        }
    }
    return node;
};

/**
 * Основная функция - Создаёт дерево типа TreeNode и запускает рекурсивную функцию для наполнения
 * @param {string} ticketId номер корневого тикета
 * @returns {TreeNode} object
 */
export const buildTree = (ticketId: string): Promise<TreeNode> => dumpStructure(ticketId);
