import {Moment} from 'moment';

export interface StartrekProperty {
    self: string;
    id: string;
    key?: string;
    display: string;
}

export interface Ticket {
    id: string;
    title?: string;
    assignee?: StartrekProperty | undefined;
    status?: StartrekProperty | undefined;
    resolution?: StartrekProperty | undefined;
    storyPoints?: number;
    originalStoryPoints?: number;
    startDate?: Moment | undefined;
    tags?: string[];
    nest?: number;
    sprint?: StartrekProperty[];
    isFinished?: boolean;
    resolvedAt?: boolean;
}

export interface TreeNode extends Ticket {
    parentId: string;
    children: TreeNode[];
    dependsOn?: string[];
}

export interface AxiosHandler {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    get: any;
    post: any;
    patch: any;
}

export interface BudgetTeamDefinition {
    name: string;
    queues: string[];
    tags: string[];
    titleContains: string[];
    titleDoesntContain: string[];
}

export interface BudgetTeamItem {
    name: string;
    spentSP: number;
    estimatedSP: number;
    numEndTasksWithoutEstimation: number;
    tags: string[];
}

export interface BudgetClass {
    teamFilter: string[];
    excludeTags: string[];
    teams: BudgetTeamItem[];
    teamDefinitions: BudgetTeamDefinition[];
    originalSP: number;
    totalSpentSP: number;
    totalEstimatedSP: number;
}

export interface FormatterSelector {
    markdown: Function;
    markdown2: Function;
    html: Function;
    text: Function;
    csv: Function;
    default: Function;
}
