import React, {useRef, useState} from "react";
import {Button} from "@yandex-lego/components/Button/desktop/bundle";
import {Popup} from "@yandex-lego/components/Popup/desktop/bundle";

let popupCloser = null;

export const ButtonWithPopup = ({label = '', children, ...props}) => {
    const anchorRef = useRef(null);
    const [visible, setVisible] = useState(false);

    const onButtonClick = () => {
        if (visible) {
            setVisible(false);
            popupCloser = null;
        }
        else {
            if (popupCloser) {
                popupCloser();
            }
            setVisible(true);
            popupCloser = () => setVisible(false);
        }
    }

    const onPopupClose = () => {
        setVisible(false);
        popupCloser = null;
    }

    return (
        <>
            <Button onClick={onButtonClick} innerRef={anchorRef} size="xs" theme='normal' {...props}>
                {label}
            </Button>
            <Popup
                target="anchor"
                anchor={anchorRef}
                direction="bottom-start"
                view="default"
                visible={visible}
                style={{ maxWidth: 280 }}
                onClose={onPopupClose}
            >
                {children}
            </Popup>
        </>
    );
};
