import React, {useState} from 'react';
import {Textinput} from "@yandex-lego/components/Textinput/desktop/bundle";
import {Button} from "@yandex-lego/components/Button/desktop/bundle";
import {HintLink} from "../../HintLink/HintLink";


export const Field = ({label = '', value, hints = [], control = null, width = 100, onChange = null}) => {
    const [isEdit, setEdit] = useState(false);
    const [controlValue, setControlValue] = useState(value);
    const fieldOnChange = onChange;
    if (!control) {
        control = (value, onChange) =>
            <Textinput
                size="s"
                view="default"
                value={value}
                onChange={(e) => onChange(e.target.value)}
                style={{width: width + 'px'}}
                onKeyPress={(e) => {if (e.which === 13) {setEdit(false); fieldOnChange(e.target.value)}}}
            />
    }
    return (
        <span>
            {!isEdit &&
            <>
                {label}:&nbsp;
                {value}&nbsp;
                <Button view="clear" size="xs" onClick={() => setEdit(true)}>
                    Изменить
                </Button>
            </>
            }
            {isEdit &&
            <span className='field-edit-content'>
                {label}:&nbsp;
                {control(controlValue, setControlValue)}
                <span className='field-edit-hints'>
                    {hints.map(({title, value}) =>
                        <>
                            &nbsp;
                            <HintLink
                                title={value}
                                onClick={() => {setControlValue(value); setEdit(false); onChange(value)}}
                            >
                                {title}
                            </HintLink>
                        </>
                    )}
                </span>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <Button view="action" size="s" onClick={() => {setEdit(false); onChange(controlValue)}}>
                    Сохранить
                </Button>
                <Button view="clear" size="s" onClick={() => {setControlValue(value); setEdit(false)}}>
                    Отмена
                </Button>
            </span>
            }
        </span>
    );
};
