import React, {RefObject} from 'react'

type MarkDownProps = {
    text: string,
    className?: string,
}

export class MarkDown extends React.PureComponent<MarkDownProps> {
    private contentRef: RefObject<HTMLDivElement> = React.createRef();
    private formatter: any;

    renderFormat = () => {
        const w: any = window;
        if (w.Ya && w.Ya.FormatterViewPort) {
            this.formatter = new w.Ya.FormatterViewPort({
                domElem: this.contentRef.current,
                settings: {
                }
            });
            this.formatter.render(this.props.text);
        }
    }

    componentWillUnmount() {
        this.formatter.remove();
    }

    componentDidMount() {
        const w: any = window;
        if (!w.Ya || !w.Ya.FormatterViewPort) {
            const head = document.getElementsByTagName('head')[0];
            let s = document.createElement('script')
            s.src = "//yastatic.net/jquery/2.2.3/jquery.min.js";
            head.appendChild(s);

            s = document.createElement('script');
            s.src = "//yastatic.net/s3/frontend/woof/v2.0.2/desktop.js";
            head.appendChild(s);

            s = document.createElement('script');
            s.innerText = 'window.WIKI_FORMATTER_CONFIG = {"remark":{"markdown":{"commonmark":true},"woofmd":{"actions":[{"name":"toc","scope":"block"}]}}};';
            head.appendChild(s);

            s = document.createElement('script');
            s.src = '//yastatic.net/s3/frontend/woof/_/socket.io.2.2.0.js';
            s.addEventListener('load', () => {
                console.log('loaded');
                this.renderFormat();
            });
            head.appendChild(s);

            const l = document.createElement('link');
            l.rel = 'stylesheet';
            l.href = '//yastatic.net/s3/frontend/woof/v2.0.2/desktop.css';
            head.appendChild(l);
        }
        window.setTimeout(() => {
            this.renderFormat();
        }, 100);
    }

    componentDidUpdate() {
        this.renderFormat();
    }

    render() {
        return <div className={this.props.className || ''} ref={this.contentRef} />;
    }
}
