import React from 'react';
import {apiAddTask, apiEditTask, taskUrl} from "../../startrek";
import {Textinput} from "@yandex-lego/components/Textinput/desktop/bundle";
import {Link} from "@yandex-lego/components/Link/desktop/bundle";
import {Button} from "@yandex-lego/components/Button/desktop/bundle";

export class TaskCreator extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            taskName: '',
            tagsStr: 'test_aaa',
        }
    }

    onInputChange = (event) => {
        this.setState({taskName: event.target.value});
    }

    getTagsArray(tagsStr) {
        const tags = [];
        for (let tag of tagsStr.split(/\s*,\s*/)) {
            tag = tag.replace(/^\s+/).replace(/\s+$/);
            if (tag) {
                tags[tags.length] = tag;
            }
        }
        return tags;
    }

    onTagsChange = (event) => {
        const tagsStr = event.target.value;
        this.setState({tagsStr});
    }

    onInputBlur = async () => {
        const {taskId, taskName, savedTaskName} = this.state;
        if (taskId && taskName !== savedTaskName) {
            this.setState({locked: true});
            await apiEditTask(taskId, {
                summary: taskName
            });
            this.setState({locked: false, savedTaskName: taskName});
        }
    }

    onKeyDown = (event) => {
        if (!this.state.locked && event.which === 13) {
            this.onCreateButtonClick();
        }
    }

    onCreateButtonClick = async () => {
        if (this.state.locked) {
            return;
        }
        const {taskName, tagsStr} = this.state;
        const tags = this.getTagsArray(tagsStr);
        this.setState({locked: true});
        const {key: taskId} = await apiAddTask({
            queue: 'ADFOX',
            summary: taskName,
            description: '',
            tags: tags,
        });
        this.setState({
            taskId,
            locked: false,
            savedTaskName: taskName,
        });
    }

    render() {
        const {taskName, tagsStr, taskId, locked} = this.state;
        const showCreate = !taskId;

        return (
            <div className='card'>
                Tags:
                <Textinput
                    className='input'
                    size="s"
                    view="default"
                    value={tagsStr}
                    disabled={locked}
                    onChange={this.onTagsChange}
                />
                <hr />
                <Textinput
                    className='input'
                    size="s"
                    view="default"
                    value={taskName}
                    disabled={locked}
                    onChange={this.onInputChange}
                    onKeyDown={this.onKeyDown}
                    onBlur={this.onInputBlur}
                />
                {taskId &&
                <Link target="_blank" view="default" href={taskUrl(taskId)}>
                    {taskId}
                </Link>
                }
                {showCreate &&
                <Button view="clear" size="s" disabled={locked} onClick={this.onCreateButtonClick}>
                    Create
                </Button>
                }
            </div>
        );
    }
}
