import React from 'react';
import {Spin} from "@yandex-lego/components/Spin/desktop/bundle";
import {apiCall} from "../../startrek";
import PropTypes from "prop-types";
import {Comment} from "./Comment";

export class AjaxComments extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            spinner: true,
            comments: []
        }
    }

    async updateComments() {
        const comments = await apiCall(`issues/${this.props.taskKey}/comments`);
        console.log(comments);
        this.setState({
            spinner: false,
            comments,
        });
    }

    componentDidMount() {
        this.updateComments();
    }

    componentDidUpdate(prevProps, prevState, snapshot) {
        if (this.props.taskKey !== prevProps.taskKey) {
            this.updateComments();
        }
    }

    render() {
        if (this.state.spinner) {
            return <div>
                <Spin progress view="default" size="l" />
            </div>
        }
        return this.state.comments.map(c => <Comment key={c.id} comment={c}/>)
    }
}

AjaxComments.propTypes = {
    taskKey: PropTypes.string.isRequired,
};
