import React from 'react'
import {MarkDown} from "../MarkDown/MarkDown";
import {User} from "../User/User";
import {DateTime} from "../DateTime/DateTime";

export const Comment = ({comment}) => (
    <div className='comment'>
        <User.Avatar user={comment.createdBy} />
        <div className='comment-body'>
            <User.Name user={comment.createdBy} />
            <DateTime className='comment-datetime' val={comment.createdAt} />
            <MarkDown className='comment-content' text={comment.text} />
        </div>
        {/*<pre>*/}
        {/*    Comment: {JSON.stringify(comment, null, 4)}*/}
        {/*</pre>*/}
    </div>
);
