import React from 'react';
import PropTypes from 'prop-types';

import './style.css';
import {User} from "../User/User";
import {Link} from "@yandex-lego/components/Link/desktop/bundle";
import {taskUrl} from "../../startrek";
import {AjaxComments} from "./AjaxComments";
import {MarkDown} from "../MarkDown/MarkDown";

export class TaskView extends React.PureComponent {
    render() {
        const task = this.props.task;
        return (
            <div className='task-view'>
                <div className='task-view-content-block task-view-header'>
                    {task.type.display}
                    <div className='task-view-task-key'>
                        <Link target="_blank" size="xs" theme="normal" href={taskUrl(task.key)}>
                            {task.key}
                        </Link>
                    </div>
                    <div className='task-view-summary'>{task.summary}</div>
                    <div className='task-view-status'>{task.status.display}</div>
                    <div className='task-view-tags'>
                        {(task.tags || []).map(t => <span className='task-view-tag' key={t}>{t}&nbsp;</span>)}
                    </div>
                    <div className='task-view-author'>
                        Автор: <User user={task.createdBy} />
                    </div>
                </div>
                <div className='task-view-content-block task-view-content'>
                    {task.description &&
                    <MarkDown className='task-view-description' text={task.description}/>
                    }
                    <AjaxComments taskKey={task.key} />
                </div>
                {/*<textarea className='task-view-dump'>*/}
                {/*    {JSON.stringify(task, null, 4)}*/}
                {/*</textarea>*/}
            </div>
        )
    }
}

TaskView.propTypes = {
    task: PropTypes.object.isRequired,
};
