import React from 'react';
import './style.css';

const UserAvatar = ({user}) => (
    <img
        className='user-avatar'
        src={`https://center.yandex-team.ru/api/v1/user/${user.id}/avatar/60.jpg`}
        alt={user.display}
        width='20'
        height='20'
    />
);

const UserName = ({user}) => (
    <span className='user-name'>
                {user.display}
    </span>
);

export const User = ({user}) => (
    <span className='user'>
        <a className='user-link' href={`https://staff.yandex-team.ru/${user.id}`} target='_blank' rel='noreferrer'>
            <UserAvatar user={user}/>
            <UserName user={user}/>
        </a>
    </span>
)

User.Avatar = ({user}) => (
    <span className='user'>
        <a className='user-link' href={`https://staff.yandex-team.ru/${user.id}`} target='_blank' rel='noreferrer'>
            <UserAvatar user={user}/>
        </a>
    </span>
)

User.Name = ({user}) => (
    <span className='user'>
        <a className='user-link' href={`https://staff.yandex-team.ru/${user.id}`} target='_blank' rel='noreferrer'>
            <UserName user={user}/>
        </a>
    </span>
)
