const DEFAULT_OPTIONS = {
    cache: 'no-cache',
    credentials: 'include',
};
export const BASE_URL =
    process.env.REACT_APP_API_TYPE === 'production' ? 'https://st.yandex-team.ru' : 'https://st.test.yandex-team.ru';

export const BASE_API_URL =
    process.env.REACT_APP_API_TYPE === 'production' ? 'https://st-api.yandex-team.ru' : 'https://st-api.test.yandex-team.ru';

export const api = (url, options = {}, parse = true) => {
    return fetch(`${BASE_API_URL}/v2/${url}`, {
        ...DEFAULT_OPTIONS,
        ...options,
    }).then(r => (parse ? r.json() : r));
};

export const apiWithHeaders = async (url, options) => {
    const res = await api(url, { ...options }, false);
    const headers = {
        totalCount: Number(res.headers.get('X-Total-Count')),
        totalPage: Number(res.headers.get('X-Total-Pages')),
    };
    if (res.status > 200) {
        throw new Error(res.statusText);
    }
    return {
        headers,
        data: await res.json(),
    };
};
