import {intersection} from "lodash";

export const indexBy = (arr, key) => {
    const result = {};
    for (const el of arr) {
        result[el[key]] = el;
    }
    return result;
}

export const ksort = (obj, inplace = true) => {
    const result = {};
    for (let k of Object.keys(obj).sort()) {
        result[k] = obj[k];
        delete obj[k];
    }
    if (inplace) {
        for (const k of Object.keys(result)) {
            obj[k] = result[k];
        }
    }
    return result;
}

window.ksort = ksort;

export const match = (pattern, obj) => {
    if (pattern instanceof Array) {
        return obj instanceof Array && intersection(pattern, obj).length === pattern.length;
    }
    if (pattern instanceof Object) {
        if (!(obj instanceof Object)) {
            return false;
        }
        for (let patternKey of Object.keys(pattern)) {
            if (!match(pattern[patternKey], obj[patternKey])) {
                return false;
            }
        }
        return true;
    }
    return obj === pattern;
}

export const inc = (obj, prop, val = 1) => {
    if (!obj[prop]) {
        obj[prop] = 0;
    }
    return obj[prop] = Math.round(10 * (obj[prop] + val)) / 10;
}

export const getPath = (obj, path, defaultValue = null) => {
    let curObj = obj;
    for (const key of path) {
        if (!(key in curObj)) {
            return defaultValue;
        }
        curObj = curObj[key];
    }
    return typeof curObj == 'number' ? Math.round(curObj * 10) / 10 : curObj;
}

export const setPath = (obj, path, value) => {
    let curObj = obj;
    const head = path.slice(0, -1);
    const tail = path.slice(-1)[0];
    for (const key of head) {
        if (!(key in curObj)) {
            curObj[key] = {};
        }
        curObj = curObj[key];
    }
    curObj[tail] = value;
}

export const countValues = (ar) => {
    const values = {};
    for (const v of Object.values(ar)) {
        inc(values, v || '(пусто)');
    }
    return ksort(values);
}

export const parseArray = (str) => {
    if (!str) return [];
    let values = str.split(/\s*,\s*/);
    if (values.length === 1 && values[0] === '') {
        values = [];
    }
    return values;
}

// TODO - оставить одну из parseArray и getTagsArray
export const getTagsArray = (tagsStr) => {
    const tags = [];
    for (let tag of tagsStr.split(/\s*,\s*/)) {
        tag = tag.replace(/^\s+/).replace(/\s+$/);
        if (tag) {
            tags[tags.length] = tag;
        }
    }
    return tags;
}

const getBool = (params, prop, defaultValue) => {
    if (!(prop in params)) {
        return defaultValue;
    }
    return params[prop] === '1';
}

export const taskCompareFn = (t1, t2) => {
    const w1 = t1.weight || 0;
    const w2 = t2.weight || 0;
    if (w1 === w2) {
        return t1.summary < t2.summary ? -1 : 1;
    }
    return w1 > w2 ? -1 : 1;
}
