import {apiCall} from '../startrek';

export const loadParentsRec = async (keys, store = {}) => {
    console.log('loadParentsRec', keys);

    const loadKeys = new Set();

    let results = [];
    const keysToLoad = [];

    for (const key of keys) {
        if (!store[key]) {
            console.log('loading parent', key);
            keysToLoad.push(key);
        }
    }

    if (keysToLoad.length) {
        results = await apiCall(encodeURI(`issues?query=Key: ${keysToLoad.join()}&perPage=500`));
    }

    for (const task of results) {
        store[task.key] = task;
    }

    for (const key of keys) {
        // задачи может не быть, если доступ к ней закрыт или она не найдена
        if (store[key] && store[key].parent && !store[store[key].parent.key]) {
            loadKeys.add(store[key].parent.key);
        }
    }

    if (loadKeys.size) {
        await loadParentsRec(loadKeys, store);
    }

    return store;
}