import { useQuery, useMutation, queryCache } from 'react-query';
import { api } from './api';
import { buildCutContent, getCutContent } from './cut';
const SETTINGS_CUT_NAME = 'settings';
function taskInputDataAdapter(data) {
    try {
        const settingsStr = getCutContent(data.description, SETTINGS_CUT_NAME);
        const clearStr = buildCutContent(settingsStr, SETTINGS_CUT_NAME);
        const description = data.description.replace('\n' + clearStr, '');
        return {
            ...data,
            description,
            retroboardSettings: JSON.parse(settingsStr),
        };
    }
    catch (_e) {
        return data;
    }
}
function taskOutputAdapter(data) {
    const { retroboardSettings = {}, description, ...taskData } = data;
    const descriptionWithMeta = description + '\n' + buildCutContent(JSON.stringify(retroboardSettings), SETTINGS_CUT_NAME);
    return {
        ...taskData,
        description: descriptionWithMeta,
    };
}
export const getTask = async (taskId) => {
    return await api(`issues/${taskId}`).then(data => taskInputDataAdapter(data));
};
export const addTask = async (data) => {
    return await api('issues', {
        method: 'POST',
        body: JSON.stringify(taskOutputAdapter(data)),
    }).then(data => taskInputDataAdapter(data));
};
export const useTask = taskId => {
    return useQuery('task', () => getTask(taskId), { refetchInterval: 5000 });
};
export const editTask = async ({ taskId, data }) => {
    const method = 'PATCH';
    return await api(`issues/${taskId}`, {
        method,
        body: JSON.stringify(taskOutputAdapter(data)),
    }).then(data => taskInputDataAdapter(data));
};
export const useAddTask = () => {
    return useMutation(addTask);
};
export const useCreateBoard = () => {
    const defaults = {
        summary: '<RetroName change me>',
        tags: ['retroboard'],
        description: '',
    };
    // @ts-ignore
    return useMutation(async (data) => {
        const task = await addTask({ ...defaults, ...data });
        await editTask({
            taskId: task.key,
            data: {
                description: `https://retroboard.yandex-team.ru#task=${task.key}`,
                retroboardSettings: task.retroboardSettings,
            },
        });
        return task;
    });
};
export const useEditTask = () => {
    return useMutation(editTask, {
        onMutate: ({ data }) => {
            queryCache.cancelQueries('task');
            const task = queryCache.getQueryData('task');
            queryCache.setQueryData('task', (taskData) => {
                return { ...taskData, ...data };
            });
            return () => queryCache.setQueryData('task', task);
        },
        onSuccess: data => {
            queryCache.setQueryData('task', (oldTask) => {
                return { ...oldTask, ...data };
            });
        },
    });
};
