// const BASE_URL =
//    process.env.REACT_APP_API_TYPE === 'production' ? 'https://st.yandex-team.ru' : 'https://st.test.yandex-team.ru';
//
// const BASE_API_URL =
//    process.env.REACT_APP_API_TYPE === 'production' ? 'https://st-api.yandex-team.ru' : 'https://st-api.test.yandex-team.ru';

// const BASE_URL = 'https://st.test.yandex-team.ru';
// const BASE_API_URL = 'https://st-api.test.yandex-team.ru';

const BASE_URL = 'https://st.yandex-team.ru';
const BASE_API_URL = 'https://st-api.yandex-team.ru';

export const taskUrl = (taskId) => BASE_URL + '/' + taskId;

const apiCallWithHeaders = async (path, data = null, method = null) => {
    const init = {
        cache: 'no-cache',
        credentials: 'include',
        method: method || (data ? 'POST' : 'GET'),
        body: data ? JSON.stringify(data) : null
    }
    return fetch(BASE_API_URL + '/v2/' + path, init)
        .then(r => ({headers: r.headers, response: r.json()}));
};


export const apiCall = async (path, data = null, method = null) =>
    (await apiCallWithHeaders(path, data, method)).response;


export const apiAddTask = async (data) => {
    return apiCall('issues', data);
};

export const apiEditTask = async (taskKey, data) => {
    return apiCall('issues/' + taskKey, data, 'PATCH');
};

export const apiSearch = async (queryStr, limit = 1000) => {
    const batchSize = 100;
    let page = 1;
    const uri = `issues?perPage=${batchSize}&query=${encodeURIComponent(queryStr)}`;

    const {headers, response} = await apiCallWithHeaders(uri);
    if (headers.has('X-Total-Count')) {
        const totalCnt = headers.get('X-Total-Count');
        if (limit > totalCnt) {
            limit = totalCnt;
        }
    }
    const promises = [response];

    while (page * batchSize < limit) {
        promises[promises.length] = apiCall(uri + '&page=' + (page + 1));
        ++page;
    }

    const results = await Promise.all(promises);

    return Array.prototype.concat.apply([], results);
};