#!/bin/bash

BETA_PORT=8022
BETA_HTTPS_PORT=8422

# check if beta is already builded
if [ -e $HOME/beta.$BETA_PORT ]
then
  # need to update branches
  echo "Beta is already builded"

  # update perl-backend
  cd $HOME/beta.$BETA_PORT
  echo "Updating partner2 master"
  git checkout master
  git pull origin master

  # update frontend
  echo "Updating yharnam master"
  cd $HOME/beta.$BETA_PORT/frontend-node
  git checkout master
  git pull origin master
else
  # need to make beta from scratch
  echo "There is no builded beta"

  cd $HOME/
  echo "Cloning partner2"
  git clone git@github.yandex-team.ru:partner/partner2.git beta.$BETA_PORT
fi

# prepare environment
export SANDBOX_API_TOKEN=`cat /etc/pi-secrets.json | jq '.["sandbox-token"]' -r`

cd $HOME/beta.$BETA_PORT
make beta_create
./nginx/init.sh restart

# make sure that beta is ready
sleep 10

ALIVE_RESPONSE=`curl -s "https://dev-partner2.yandex.ru:$BETA_HTTPS_PORT/v2/alive"`
echo $ALIVE_RESPONSE

if [[ $ALIVE_RESPONSE == "Alive" ]]
then
  /usr/bin/juggler_queue_event --host `hostname -f` --service check-dev-partner-beta --status OK --description 'Beta builded correctly'
else
  /usr/bin/juggler_queue_event --host `hostname -f` --service check-dev-partner-beta --status CRIT --description "Beta wasn't builded correctly. Check logs"
fi
