#!/usr/bin/perl
use DateTime;
use feature 'say';

my $MIN_COUNT_OF_DB_IMAGES = 2;
my @images = grep { $_ =~ /partner2-db-(general|mentol|autotest)/ } split '\n',
  `/usr/bin/docker images --format="{{.Repository}} {{.ID}} {{.CreatedAt}}"`;
my $images_count = @images;

my $save_images = {
    day   => 2,
    week  => 0,
    month => 0,
};

say DateTime->now()->datetime, " START";
foreach my $key ( keys %$save_images ) {
    my $dt = DateTime->today()->truncate( to => $key );
    foreach ( 1 .. $save_images->{$key} ) {
        my $pattern = $dt->ymd;
        @images = grep { $_ !~ /$pattern/ } @images;
        $dt->subtract( "${key}s" => 1 );
    }
}

if ( $images_count - @images < $MIN_COUNT_OF_DB_IMAGES ) {
    say "The number of remaining images is less than the threshold value";
}
else {
    foreach $db_image (@images) {
        my $id = ( split ' ', $db_image )[1];
        say `/usr/bin/docker rmi -f $id`;
    }

    say `/usr/bin/docker image prune -a --force`;
}

say DateTime->now()->datetime, " END";
