/* Специальные настройки, которых не должно быть в продакшн базе, но должно быть на тестовой базе */
/* При добавлении пользоватей нужно добавть email в домене yandex-team.ru, чтобы упростить индетификацию пользователей */

/* РОЛИ - https://wiki.yandex-team.ru/partner/w/partner2-roles */

/* внутренние роли ПИ */
set @ROLE_DEVELOPER=2;

/* AN - Внутренние роли СЯ */
set @ROLE_AN_MANAGER=3;
set @ROLE_AN_ADMINISTRATOR=4;
set @ROLE_AN_VIEWER=19;

/* YAN - Внешние роли РСЯ */
set @ROLE_YAN_DSP_PARTNER=7;
set @ROLE_YAN_DSP_MANAGER=8;
set @ROLE_YAN_PARTNER=9;
set @ROLE_YAN_MANAGER=15;
set @ROLE_YAN_MODERATOR=16;
set @ROLE_YAN_VIEWER=17;
set @ROLE_YAN_ADBLOCK_PARTNER=36;
set @ROLE_YAN_VIDEO_PARTNER=20;
set @ROLE_YAN_MOBILE_PARTNER=27;

/* Удаляем дефолтные виджеты у всех пользователей которые используются тестировщиками (см. PI-8402 и PI-8874) */

set @WIDGET_SETTINGS='[{"width":"half","first":"1","type":"revenue","deletable":"0","settings":{},"accessor":"widget_revenue"}]';
set @WIDGET_DELETED='{"statistics_all_payments": 1,"statistics_dsp_report": 1,"statistics_dsp_detailed_report": 1,"statistics_context_income": 1,"statistics_context_report": 1,"statistics_search_income": 1,"statistics_search_report": 1,"statistics_mobile_income": 1,"statistics_mobile_report": 1,"statistics_video_income": 1,"statistics_video_site_report": 1,"statistics_internal_context_income": 1,"statistics_internal_search_income": 1,"statistics_internal_mobile_income": 1,"statistics_internal_advnet_report": 1,"statistics_internal_context_report": 1,"statistics_internal_search_report": 1,"statistics_internal_mobile_report": 1,"summary": 1}';

insert into widgets (user_id, json_widgets_settings, json_default_deleted_ids, multistate)
select uid,  @WIDGET_SETTINGS, @WIDGET_DELETED, 2
from (
         select distinct users.id as uid
         from users
                  join user_role on user_role.user_id = users.id
         where users.login like 'yndx-%'
           and user_role.role_id in (
                                     @ROLE_DEVELOPER,
                                     @ROLE_AN_MANAGER,
                                     @ROLE_AN_ADMINISTRATOR,
                                     @ROLE_YAN_DSP_MANAGER,
                                     @ROLE_YAN_MANAGER
             )
     ) as dt
on duplicate key update json_widgets_settings = values(json_widgets_settings), json_default_deleted_ids=values(json_default_deleted_ids);

/* INTAPI - start */

/* INFRASTRUCTUREPI-1766  */
update intapi_acl set acl = '_C_ADFOX_LOGIN_ _C_ADFOX_RSYA_DEV_LOGIN_ _ADFOXNETS_ _ADFOX_AUTOTEST_' where path = 'adfox';

/* TODO похоже устарело  Для тестового инстанса микросервиса "Главная страница ПИ2" https://github.yandex-team.ru/partner/lothric */
update intapi_acl set acl = '_PPCTESTNETS_' where path = 'main_page' and method = 'user_id_has_role_in_partner2';

/* PI-8915 */
update intapi_acl set acl = concat(acl, ' ', '_C_YABS_NANPU_TESTING_, _C_YABS_NANPU_UNSTABLE_') where path = 'nanpu' and acl not like '%_C_YABS_NANPU_TESTING_, _C_YABS_NANPU_UNSTABLE_%';

/* PI-11174 */
update intapi_acl set acl = '_C_WMC_DEV_MISC_  _C_WMC_BACK_TESTING_  _C_WMC_GENERATOR_TESTING_  _WMCDEVNETS_' where path = 'webmaster' and method='get_turbo';
/* PI-14834 */
update intapi_acl set acl = '_C_WMC_DEV_MISC_  _C_WMC_BACK_TESTING_  _C_WMC_GENERATOR_TESTING_  _WMCDEVNETS_' where path = 'webmaster' and method='get_turbo_v2';

/* PI-9198 */
insert ignore into intapi_acl (`path`, `method`, `acl`) values ('zen', 'internal_context_rtb_tag_stat', '_C_PORTAL_ZEN_DEV_RECOMMENDERS_') ON DUPLICATE KEY UPDATE `acl` = '_C_PORTAL_ZEN_DEV_RECOMMENDERS_';

/* INFRASTRUCTUREPI-2019 */
update intapi_acl set acl = concat(acl, " 0.0.0.0/0 0000:0000:0000:0000:0000:0000:0000:0000/0") where method = 'user_id_has_role_in_partner2' and acl not like '%0.0.0.0/0 0000:0000:0000:0000:0000:0000:0000:0000/0%';

/* Для тестового инстанса микросервиса "Анкета" https://a.yandex-team.ru/arc_vcs/partner/frontend/form */
update intapi_acl set acl = '0.0.0.0/0 0000:0000:0000:0000:0000:0000:0000:0000/0' where path = 'form';

/* MSTAT-5225 */
update intapi_acl set acl = '_GENCFG_MARKET_TEST_' where path = 'market' and method = 'page_change_log';

/* PI-12114 */
update intapi_acl set acl = '_C_VERTIS_TEST_BACK_NONRT_  _C_VERTIS_TEST_DOCKER_' where path = 'adv-vertis' and  method = 'page_stat';

/* PI-15471 */
update `intapi_acl` set `acl`='_C_PARTNER_OLD_TEST_ or _C_PARTNER_RTB_TEST_ or _C_PARTNER_RTB_DEV_ or _C_PARTNER_RTB_TESTNETS_DEV_ or _C_PARTNER_OLD_DEV_ or _C_PASSPORT_CLOUD_TAKEOUT_TESTING_'
where `path` = 'takeout' and `method` = 'takeout';


/* intapi - end */


/* <PI-13413 - increase "page_id_generator" AUTO_INCREMENT */
set @NEW_AUTO_INCREMENT=( select max(page_id) + 10000  from  page_id_generator );
set @SQL = concat('ALTER TABLE page_id_generator AUTO_INCREMENT=', @NEW_AUTO_INCREMENT);

PREPARE stmt from @SQL;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
/* </PI-13413 */
