#!/bin/bash

TOKEN_WIKI=$(     cat /etc/pi-secrets.json | jq -r '.["wiki-token"]'     )
TOKEN_STARTREK=$( cat /etc/pi-secrets.json | jq -r '.["startrek-token"]' )
TOKEN_GIT=$(      cat /etc/pi-secrets.json | jq -r '.["github_token"]'   )

name="partner.yandex-team.ru"

docker run \
    --net=host \
    -e "YANDEX_WIKI_OAUTH_TOKEN=$TOKEN_WIKI" \
    -e "STARTREK_OAUTH_TOKEN=$TOKEN_STARTREK" \
    -e "GITHUB_OAUTH_TOKEN=$TOKEN_GIT" \
    -e 'SLACK_INTEGRATION_URL=https://hooks.slack.com/services/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' \
    --volume=/var/www/partner.yandex-team.ru/bin:/app/bin \
    --volume=/var/www/partner.yandex-team.ru/lib:/app/lib \
    --volume=/var/www/partner.yandex-team.ru/templates:/app/templates \
    --name $name \
    $name
