#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use base qw(Exporter);

use JSON::PP;

our @EXPORT_OK = qw(get_secret);
our @EXPORT = @EXPORT_OK;

my $LAST_MODIFIED;

my $SECRETS;

my $SECRETS_FILE = '/etc/pi-secrets.json';

sub get_secrets {
    my $last_modified = (stat $SECRETS_FILE)[9];

    if (!defined($SECRETS) || $LAST_MODIFIED < $last_modified) {
        my $json = read_file();

        $SECRETS = JSON::PP->new->utf8->decode($json);

        if (my @env_secret_names = grep {m/^SECRET_/} keys(%ENV)) {
            for my $env_secret_name (@env_secret_names) {
                my ($secret_name) = ($env_secret_name =~ m/^SECRET_(.*)$/);
                $secret_name =~ s/_/-/g;
                $secret_name = lc($secret_name);
                $SECRETS->{$secret_name} = $ENV{$env_secret_name};
            }
        }

        $LAST_MODIFIED = $last_modified;
    }

    return $SECRETS;
}

sub get_secret {
    my ($key) = @_;

    my $secrets = get_secrets();

    die "No key '$key' in the secrets file $SECRETS_FILE or ENV" unless exists $secrets->{$key};

    return $secrets->{$key};
}

sub read_file {
    open(my $fh, '<', $SECRETS_FILE) or die $!;

    binmode($fh, ':utf8');

    my $json_config = join('', <$fh>);

    close($fh) or die $!;

    return $json_config;
}

1;
