server {

    listen 80;
    listen [::]:80;

    server_name registry.partner.yandex-team.ru;

    access_log /var/log/nginx/registry.partner.yandex-team.ru.access.log;
    error_log  /var/log/nginx/registry.partner.yandex-team.ru.error.log;

    rewrite ^(.*) https://$host$1 permanent;
}

server {

    listen 443 ssl;
    listen [::]:443 ssl;

    server_name registry.partner.yandex-team.ru;

    ssl on;
    ssl_certificate /etc/nginx/ssl/registry.partner.yandex-team.ru.pem;
    ssl_certificate_key /etc/nginx/ssl/registry.partner.yandex-team.ru.pem;
    ssl_protocols       SSLv3 TLSv1;

    add_header Strict-Transport-Security "max-age=31536000; includeSubDomains";

    access_log /var/log/nginx/registry.partner.yandex-team.ru.access.log;
    error_log  /var/log/nginx/registry.partner.yandex-team.ru.error.log;

    client_max_body_size 0;
    proxy_set_header Host $http_host;

    location / {
        auth_basic              "Restricted";
        auth_basic_user_file    registry.partner.yandex-team.ru.htpasswd;

        proxy_pass http://127.0.0.1:12010;
    }

}
