#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Date::Calc qw(Add_Delta_YMD);

my $DUMP_NAME = 'statistics_dump.tsv';

my $SQL_INSERT = 'INSERT INTO statistics FORMAT TabSeparatedWithNames';

my $CH_CONNECTS = [
    {
        name    => 'DEV 2',
        query   => sub {
            qq[--query="$_[0]"]
        },
        connect => 'clickhouse-client stat',
    },
    {
        name    => 'TS',
        query   => sub {
            qq[-- --query="'$_[0]'"]
        },
        connect => 'clickhouse_mdb --server=ts',
    },
    {
        name    => 'DEV',
        query   => sub {
            qq[--query="$_[0]"]
        },
        connect => 'clickhouse-client --host="dev-partner.yandex.ru" stat',
    },
];

main();

sub main {
    my ($date, $first_date) = get_dates();

    print "START: $date\n";

    my $sql = "SELECT * FROM statistics WHERE dt = '$date' format TabSeparatedWithNames";

    print "GET STATISTICS FROM PROD\n";

    print `echo "$sql" | clickhouse_mdb --server=prod | sed '1d' > $DUMP_NAME`;

    foreach my $ch (@$CH_CONNECTS) {
        print "DELETE ROWS FROM $ch->{'name'}\n";

        my $sql_delete = "ALTER TABLE statistics DELETE WHERE dt = '$date' OR dt < '$first_date'";

        print `echo "$sql_delete" | $ch->{'connect'}`;

        print "COPY STATISTICS INTO $ch->{'name'} CLICKHOUSE\n";

        my $query = $ch->{'query'}->($SQL_INSERT);

        print `$ch->{'connect'} $query < $DUMP_NAME`;
    }

    print "REMOVE FILE $DUMP_NAME\n";
    print `rm $DUMP_NAME`;

    print "END: $date\n";
}

sub get_dates {
    my $date = $ARGV[0];

    unless (defined($date)) {
        my @date = localtime();

        my $year = 1900 + $date[5];
        my $month = 1 + $date[4];
        my $day = $date[3];

        my @res = Add_Delta_YMD($year, $month, $day, 0, 0, -1);

        $date = sprintf("%d-%02d-%02d", @res);
    }

    my @delta = Add_Delta_YMD(split(/-/, $date), -1, 0, 0);
    my $first_date = sprintf("%d-%02d-%02d", @delta);

    return ($date, $first_date);
}
