#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Carp qw( croak );
use Data::Dumper;

use Yandex::Wiki;


my $W_INDEX_URL = '/partner/w-index';
my $AUTO_CONTENT_START_MARKER = '==(auto-generated-text-below)AUTO INDEX';


#####
main();
#####


sub main {

    my $token_wiki=`cat /etc/pi-secrets.json | jq -r '.["wiki-token"]'`;

    binmode STDOUT, ':utf8';

    my $wiki_obj = Yandex::Wiki->new(
         oauth_token => $token_wiki
    );

    my $result = $wiki_obj->get_all_children( '/partner/w/',
        depth          => 10,
        sort_by        => 'cluster',
        show_redirects => 'False',
        show_grids     => 'True',
        show_files     => 'False',
    );

    my $articles = [];

    print "Start process ", scalar(@{ $result->{data}->{subpages} }), " pages\n";

    process_children_recursevely($wiki_obj, $result->{data}->{subpages}, $articles );

    print " - OK \n";

    my $content = sprintf q[
%s
!!**NOTE!** Автоматически сгенерированный контент, не редактируйте его самостоятельно, **ручные правки** затрутся!!!
  Страница создана с помощью скрипта ((https://a.yandex-team.ru/arc_vcs/partner/infra/partner_ansible/roles/w_index/files/partner_w_index.pl)).
  У вики есть макрос %%%%{{tree}}%%%%, но к сожалению, он работает неправильно (баг ((http://st.yandex-team.ru/WIKI-4688 WIKI-4688)))),
  поэтому пришлось написать скрипт, который создает индекс ((/partner/w нашей маленькой википедии)).

%s
], $AUTO_CONTENT_START_MARKER, join("\n", @$articles);

    save_page_on_content_change(
        wiki_obj     => $wiki_obj,
        start_marker => $AUTO_CONTENT_START_MARKER,
        url          => $W_INDEX_URL,
        content      => $content,
        title        => 'Список страниц википедии о партнерском интерфейсе ',
    );

}


sub process_children_recursevely {
    my ( $wiki_obj, $data, $articles, $redirects, $depth, $indent ) = @_;

    $depth //= 0;
    $indent //= '';

    my $count = 0;
    foreach my $child ( @$data ) {
        $count++;
        my $prefix      = sprintf("%s%d. ", $indent, $count);
        my $ident_child = ' ' x length($prefix);

        my ( $title, $url ) = @{ $child->{page} }{qw( title  url )};

        (my $name = $url ) =~ s|^.*/||;
        print $indent, $count, '. ', $name, "\n";

        unless (defined $title) {
            push @$articles, sprintf("%s%s", $prefix, $name);
        }
        else {
            push @$articles, sprintf("%s((%s %s)) — %s", $prefix, $url, $name, $title );
        }

        my $subpages = $child->{subpages} // [];
        process_children_recursevely( $wiki_obj, $subpages, $articles, $redirects, $depth+1, $ident_child ) if @$subpages;
    }
}

sub save_page_on_content_change {
    my (%opts) = @_;

    my ( $wiki_obj, $url, $content, $title, $start_marker ) = @opts{qw( wiki_obj  url  content  title  start_marker )};

    croak "Expected to recieve 'url'. Stopped"     unless defined $url;
    croak "Expected to recieve 'content'. Stopped" unless defined $content;
    croak "Expected to recieve 'title'. Stopped"   unless defined $title;

    my $auto_content = $wiki_obj->get_page( $url );

    my $user_content = '';
    if ( $start_marker ){
        ( my $regex_start_marker = $start_marker ) =~ s|([(){}\[\].*?])|\\$1|g; # escape special sumpols
        if ( $auto_content =~ m/(.*?)($regex_start_marker.*)$/s ) {
            $user_content = $1;
            $auto_content = $2;
        }
    }

    if ( $auto_content ne $content ){

        $wiki_obj->save_page(
            url     => $url,
            content => $user_content . $content,
            title   => $title,
        );
    }

    return 1;
}



