#!/bin/bash

endpointset_filename=deploy_endpointsets
endpoint_filename=deploy_endpoints

ya tool dctl list es | tail -n +4 | head -n -1 | awk '{print $4}' | sort | uniq -i | grep '^partner' > "$endpointset_filename" 

rm "$endpoint_filename"
touch "$endpoint_filename"

declare -a stages=("production" "test" "preprod" "autotest")
declare -a units=("backend" "database")

for stage in "${stages[@]}"; do
    target="partner-$stage-stage"
    for unit in "${units[@]}"; do
        echo "TARGET: $target.$unit"
        echo "[$stage-$unit]" >> "$endpoint_filename"
        endpoints=$(cat "$endpointset_filename" | grep -i "$target" | grep -i "$unit")
        if [[ -n "$endpoints" ]]; then
          echo "$endpoints"  | xargs -n 1 ya tool dctl list ep | grep "yandex.net" | awk '{print $7, "ansible_host=" $9}' >> "$endpoint_filename"
        fi
        echo '' >> "$endpoint_filename"
    done

    echo "[$stage:children]" >> "$endpoint_filename"
    for unit in "${units[@]}";
    do
        echo "$stage-$unit" >> "$endpoint_filename"
    done
    echo '' >> "$endpoint_filename"
done

