package infra;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonProperty;

public class InfraEvent {
    private String title;
    @JsonProperty("start_time_iso")
    private LocalDateTime startTime;
    @JsonProperty("finish_time_iso")
    private LocalDateTime finishTime;

    InfraEvent() {
        // Jackson needed
    }

    public String getTitle() {
        return title;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public LocalDateTime getFinishTime() {
        return finishTime;
    }


    @Override
    public String toString() {
        return "InfraEvent{" +
                "title='" + title + '\'' +
                ", startTime=" + startTime +
                ", finishTime=" + finishTime +
                '}';
    }
}
