#!/bin/bash -e

APP_ROOT=${1:-/app/java/hourglass}

/usr/bin/java -cp "$APP_ROOT/lib/*:" \
    -Djava.library.path="$APP_ROOT/lib/" \
    -Dspring.profiles.active=$HOURGLASS_PROFILE \
    -Dserver.port=${HOURGLASS_SERVER_PORT} \
    -Dmanagement.server.port=${HOURGLASS_MANAGEMENT_PORT:-9792} \
    -Dspring.pid.file=${HOURGLASS_PID_FILE:-/var/run/hourglass.pid} \
    ${JAVA_OPTS} \
    -Xmx4g \
    ru.yandex.partner.hourglass.App
