#!/bin/bash -e

export HOURGLASS_PORT=8080
export HOURGLASS_DEBUG_PORT=5005
export HOURGLASS_MANAGEMENT_PORT=9792

export MYSQL_HOST=`perl -E 'use Partner::DB; print Partner::DB::get_db_partner2(server => dev)->{host};'`
export MYSQL_PORT=`perl -E 'use Partner::DB; print Partner::DB::get_db_partner2(server => dev)->{port};'`
export MYSQL_USER=`perl -E 'use Partner::DB; print Partner::DB::get_db_partner2(server => dev)->{user};'`
export MYSQL_PASSWORD=`perl -E 'use Partner::DB; print Partner::DB::get_db_partner2(server => dev)->{password};'`

export API_KEY_TOKEN=`jq -r .[\"apikey-token\"] /etc/pi-secrets.json`

export DEPLOY_TVM_TOOL_URL=http://localhost:18080
export TVMTOOL_LOCAL_AUTHTOKEN=`cat /var/lib/tvmtool/local.auth`
export SECRET_PARTNER2_CLICKHOUSE_USER=`jq -r .[\"partner2-clickhouse-user-testing\"] /etc/pi-secrets.json`
export SECRET_PARTNER2_CLICKHOUSE_PASSWORD=`jq -r .[\"partner2-clickhouse-password-testing\"] /etc/pi-secrets.json`
export SECRET_YQL_TOKEN=`jq -r .[\"yql-token\"] /etc/pi-secrets.json`
export SECRET_YT_TOKEN=`jq -r .[\"yt-token\"] /etc/pi-secrets.json`

ya tool java17 -cp "./yandex-partner-java-hourglass/*:" \
    -Djava.library.path="./yandex-partner-java-hourglass/" \
    -agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:$HOURGLASS_DEBUG_PORT \
    ru.yandex.partner.hourglass.App \
    --spring.profiles.active=dev,debugjob \
    --server.port=$HOURGLASS_PORT \
    --management.server.port=$HOURGLASS_MANAGEMENT_PORT \
    --logging.level.root=INFO \
    $@
