package ru.yandex.partner.hourglass;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.ApplicationPidFileWriter;

// DbCheck вместо DataSourceHealthContributorAutoConfiguration
@SpringBootApplication(exclude = DataSourceHealthContributorAutoConfiguration.class)
@SuppressWarnings("HideUtilityClassConstructor")
public class App {
    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(App.class);
        app.addListeners(new ApplicationPidFileWriter());
        app.run(args);
    }
}
