package ru.yandex.partner.hourglass.configuration;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.juggler.AsyncHttpJugglerClient;
import ru.yandex.direct.juggler.JugglerAsyncSender;
import ru.yandex.direct.juggler.JugglerSender;
import ru.yandex.partner.core.configuration.BlackBoxAndTvmConfiguration;
import ru.yandex.partner.core.configuration.CoreConfiguration;
import ru.yandex.partner.defaultconfiguration.DefaultPartnerConfiguration;
import ru.yandex.partner.defaultconfiguration.rpc.DefaultRpcConfig;
import ru.yandex.partner.hourglass.configuration.property.AsyncHttpClientProperty;
import ru.yandex.partner.libs.extservice.balance.BalanceService;
import ru.yandex.partner.libs.extservice.balance.BalanceXmlRpcConfig;
import ru.yandex.partner.libs.extservice.balance.SimpleBalanceService;
import ru.yandex.partner.libs.juggler.JugglerCheckApiClient;
import ru.yandex.partner.libs.memcached.DummyMemcachedService;
import ru.yandex.partner.libs.memcached.MemcachedService;

@Configuration
@Import({
        BlackBoxAndTvmConfiguration.class,
        CoreConfiguration.class,
        HourglassConfiguration.class,
        YqlJdbcConfiguration.class,
        DefaultPartnerConfiguration.class,
})
public class AppConfiguration {

    @Bean
    public BalanceXmlRpcConfig balanceXmlRpcConfig(DefaultRpcConfig defaultRpcConfig) {
        return new BalanceXmlRpcConfig(defaultRpcConfig);
    }

    @Bean
    public BalanceService balanceService(BalanceXmlRpcConfig rpcConfig) {
        return new SimpleBalanceService(rpcConfig);
    }

    @Bean
    JugglerSender jugglerClient(@Value("${juggler.eventsGateway}") String eventsGateway,
                                AsyncHttpClient asyncHttpClient) {
        return new JugglerAsyncSender(new AsyncHttpJugglerClient(eventsGateway, true,
                asyncHttpClient));
    }

    @Bean
    AsyncHttpClient asyncHttpClient(AsyncHttpClientProperty property) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
        builder.setRequestTimeout(property.getRequestTimeout());
        builder.setReadTimeout(property.getReadTimeout());
        builder.setConnectTimeout(property.getConnectionTimeout());
        builder.setConnectionTtl(property.getConnectionTtl());
        builder.setPooledConnectionIdleTimeout(property.getPooledConnectionIdleTimeout());
        builder.setIoThreadsCount(property.getThreadsCount());
        builder.setNettyTimer(new HashedWheelTimer(
                new ThreadFactoryBuilder().setNameFormat("ahc-timer-%02d").setDaemon(true).build()));

        return new DefaultAsyncHttpClient(builder.build());
    }

    @Bean
    public MemcachedService memcachedService() {
        return new DummyMemcachedService();
    }

    @Bean
    public JugglerCheckApiClient jugglerCheckApiClient(
            @Value("${juggler.checksGateway}") String baseUrl,
            @Value("${juggler.oauthToken}") String apiToken) {
        return new JugglerCheckApiClient(baseUrl, apiToken);
    }
}
