package ru.yandex.partner.hourglass.configuration;

import javax.annotation.PostConstruct;

import ru.yandex.direct.scheduler.hourglass.TaskListProvider;
import ru.yandex.direct.scheduler.hourglass.implementations.JobScheduleInfoFactory;
import ru.yandex.direct.scheduler.hourglass.implementations.ScheduleRecordListProviderImpl;
import ru.yandex.direct.scheduler.hourglass.implementations.TaskParameterizer;
import ru.yandex.direct.scheduler.hourglass.implementations.schedule.Base64Codec;
import ru.yandex.direct.scheduler.hourglass.implementations.schedule.Codec;
import ru.yandex.direct.scheduler.hourglass.schedule.ScheduleInfoConverter;

public class ScheduleRecordListProviderPartnerImpl extends ScheduleRecordListProviderImpl {
    private final Codec scheduleInfoCodec;

    public ScheduleRecordListProviderPartnerImpl(TaskListProvider taskListProvider,
                                                 ScheduleInfoConverter scheduleInfoConverter,
                                                 TaskParameterizer taskParameterizer,
                                                 JobScheduleInfoFactory jobScheduleInfoFactory) {
        super(taskListProvider, scheduleInfoConverter, taskParameterizer, jobScheduleInfoFactory);

        this.scheduleInfoCodec = new Base64Codec();
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();

        super.getRecords().forEach(record -> record.setNameHashSum(scheduleInfoCodec.encode(record.getName())));
    }
}
