package ru.yandex.partner.hourglass.configuration;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

import ru.yandex.yql.YqlDriver;

@Configuration
public class YqlJdbcConfiguration {

    @Bean(name = "yqlDataSource")
    public DataSource yqlDataSource(
            @Value("${yql.token}") String yqlToken,
            @Value("${yql.jdbcUrl}") String yqlJdbcUrl,
            @Value("${yql.username}") String yqlUsername
    ) {
        SimpleDriverDataSource simpleDriverDataSource = new SimpleDriverDataSource();
        simpleDriverDataSource.setDriverClass(YqlDriver.class);
        simpleDriverDataSource.setUrl(yqlJdbcUrl);
        simpleDriverDataSource.setPassword(yqlToken);
        simpleDriverDataSource.setUsername(yqlUsername);

        return simpleDriverDataSource;
    }

    @Bean(name = "yqlJdbcTemplate")
    public JdbcTemplate yqlJdbcTemplate(@Qualifier("yqlDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }
}
